//import org.openstreetmap.gui.jmapviewer.*;

import java.io.Serializable;
import java.util.UUID;

/**
 *
 */
public class ZonaAtaque implements Serializable{
	protected double lat;
	protected double lon;
	private double raio;
	private UUID ZoneId;
	private String player;
	protected int pontos = 10;
	public String toString(){return "ZA : "+player+" - "+pontos; }

	public ZonaAtaque(double lat_, double lon_,double raio_,UUID id,String player_){
		lat = lat_;
		lon = lon_;
		raio = raio_;
		ZoneId = id;
		player = player_;
	}
	public ZonaAtaque(){
		lat = Math.random()*180 - 90;
		lon = Math.random()*360 - 180;
		raio = Math.random()*30 + 10;
		ZoneId = UUID.randomUUID();
		player = ZoneId.toString();
	}
	public ZonaAtaque(String username, double raio_){
		lat = Math.random()*180 - 90;
		lon = Math.random()*360 - 180;
		raio = raio_;
		ZoneId = UUID.randomUUID();
		player = username;
	}

	public boolean contem (double lat_, double lon_){
		double distance = Math.sqrt( (lat-lat_)*(lat-lat_) + (lon-lon_)*(lon-lon_) );
		return distance < raio ;
	}

	public UUID getZoneId() {return ZoneId;}

	public double getRaio() {return raio;}

	public double getLat() {return lat;}

	public double getLon() {return lon;}

	public String getPlayer() {return player;}
}