import lac.cnclib.net.*;
import lac.cnclib.net.mrudp.MrUdpNodeConnection;
import lac.cnclib.sddl.*;
import lac.cnclib.sddl.message.*;
import lac.cnclib.sddl.serialization.*;
import lac.cnet.sddl.objects.*;
import lac.cnet.sddl.objects.Message;
import lac.cnet.sddl.udi.core.*;
import lac.cnet.sddl.udi.core.listener.*;

import java.io.*;
import java.net.InetSocketAddress;
import java.util.*;

/**
 * Created by ranieri on 30/10/2016.
 */
public class StatusJogoServidor implements Serializable, UDIDataReaderListener<ApplicationObject> {
	protected List<ZonaAtaque> players = new LinkedList<>();

	/**
	 *
	 * @param newZone a zona de um player novo, ou um antigo que trocou de zona
	 * @return as zonas que foram atacadas pela entrada de newZone (alvos)
	 */
	public LinkedList<ZonaAtaque> alvosDaNovaZona(ZonaAtaque newZone){
		ZonaAtaque oldZone = null;
		LinkedList<ZonaAtaque> alvos = new LinkedList<>();
		newZone.pontos = 10;                         // CHANGE PARAMETER READ-ONLY?
		ListIterator<ZonaAtaque> it = players.listIterator();
		while(it.hasNext() ){
			oldZone = it.next();
			if (oldZone.getPlayer().equals(newZone.getPlayer()) /*&& oldZone.getZoneId().equals(newZone.getZoneId())*/ ) {
				it.remove();
				newZone.pontos = oldZone.pontos;
			}else if(newZone.contem(oldZone.getLat(),oldZone.getLon())){
				alvos.add(oldZone);
			}
		}
		if (alvos.size() <= 2) {
			if (alvos.size() > 0)
				newZone.pontos += alvos.size(); // ZERO SUM GAME
			for (ZonaAtaque target : alvos) { target.pontos += -1; }
		} else {
			newZone.pontos += - alvos.size();
			for (ZonaAtaque target : alvos) { target.pontos += 1; }
		}
		players.add(newZone);
		alvos.add(newZone);
		return alvos;
	}



	SddlLayer core;

	public static void main(String[] args) {
	//	Logger.getLogger("").setLevel(Level.OFF);
		new StatusJogoServidor();
	}
	public StatusJogoServidor() {
		core = UniversalDDSLayerFactory.getInstance();
		core.createParticipant(UniversalDDSLayerFactory.CNET_DOMAIN);

		core.createPublisher();
		core.createSubscriber();

		Object receiveMessageTopic = core.createTopic(Message.class, Message.class.getSimpleName());
		core.createDataReader(this, receiveMessageTopic);

		Object toMobileNodeTopic = core.createTopic(PrivateMessage.class, PrivateMessage.class.getSimpleName());
		core.createDataWriter(toMobileNodeTopic);

		System.out.println("=== Server Started (Listening) ===");
		synchronized (this) {
			try {
				this.wait();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

	public void onNewData(ApplicationObject topicSample) {
		System.out.println("new data in :");
		Message message = (Message) topicSample;
		Serializable s = (Serialization.fromJavaByteStream(message.getContent()));
		System.out.println(s);

		PrivateMessage privateMessage = new PrivateMessage();
		privateMessage.setGatewayId(message.getGatewayId());
		privateMessage.setNodeId(message.getSenderId());

		if (s instanceof ZonaAtaque){
			ZonaAtaque z = (ZonaAtaque) s;
			LinkedList<ZonaAtaque> attacklist = null;
			LinkedList<ZonaAtaque> vizinhanca = null;
			synchronized (core){
				attacklist = alvosDaNovaZona(z);
				vizinhanca = vizinhosDaNovaZona(z);
			}
			ApplicationMessage appMsg = new ApplicationMessage();
			appMsg.setContentObject( attacklist );
			appMsg.setRecipientID( ((Message) topicSample).getSenderId() );
			privateMessage.setMessage(Serialization.toProtocolMessage(appMsg));
			//privateMessage.setNodeId(topicSample. );

			core.writeTopic(PrivateMessage.class.getSimpleName(), privateMessage);
			System.out.println("enviou ::: " + attacklist);
			System.out.println("STATUS ::: " + players);
			for (ZonaAtaque player: vizinhanca){
					PrivateMessage privateMessage_2 = new PrivateMessage();
					privateMessage_2.setGatewayId( message.getGatewayId() );
					privateMessage_2.setNodeId( player.getZoneId() );
					ApplicationMessage appMsg_2 = new ApplicationMessage();
					appMsg_2.setContentObject( z );      // enviar novo player para players na mesma area
					appMsg_2.setRecipientID( player.getZoneId() );
					privateMessage_2.setMessage(Serialization.toProtocolMessage(appMsg_2));
					core.writeTopic(PrivateMessage.class.getSimpleName(), privateMessage_2);
					System.out.println("enviou ::: " + player );
			}
			for (ZonaAtaque alvo: attacklist) {
				PrivateMessage privateMessage_3 = new PrivateMessage();
				privateMessage_3.setGatewayId( message.getGatewayId() );
				privateMessage_3.setNodeId( alvo.getZoneId() );
				ApplicationMessage appMsg_3 = new ApplicationMessage();
				appMsg_3.setContentObject( alvo.pontos );  // enviar nova pontuacao para cada player
				appMsg_3.setRecipientID( alvo.getZoneId() );
				privateMessage_3.setMessage(Serialization.toProtocolMessage(appMsg_3));
				core.writeTopic(PrivateMessage.class.getSimpleName(), privateMessage_3);
				System.out.println("enviou : " + alvo.pontos + " to " + alvo);
			}
		} else if (s instanceof String){
			String str = (String) s;
			for (ZonaAtaque z: players){
				if (z.getPlayer().equals(str) ){
					ApplicationMessage appMsg = new ApplicationMessage();
					appMsg.setContentObject( z );
					appMsg.setRecipientID( message.getSenderId() );
					privateMessage.setMessage(Serialization.toProtocolMessage(appMsg));
					core.writeTopic(PrivateMessage.class.getSimpleName(), privateMessage);
					System.out.println("enviou ::: " + z);
				}
			}
		}
/*
		try {
			MrUdpNodeConnection con = new MrUdpNodeConnection();
			con.connect(new InetSocketAddress("127.0.0.1",5500));
			con.sendMessage(appMsg);
		} catch (IOException e) {
			e.printStackTrace();
		}
*/
	}

	public LinkedList<ZonaAtaque> vizinhosDaNovaZona(ZonaAtaque z) {
		LinkedList<ZonaAtaque> result = new LinkedList<ZonaAtaque>();
		for (ZonaAtaque player : players) {
			if (!player.getPlayer().equals(z.getPlayer()) && player.contem(z.getLat(), z.getLon())) {
				result.add(player);
			}
		}
		return result;
	}
}
