import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.util.List;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import lac.cnclib.net.*;
import lac.cnclib.net.groups.*;
import lac.cnclib.net.mrudp.MrUdpNodeConnection;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnclib.sddl.message.Message;
import org.openstreetmap.gui.jmapviewer.*;
import org.openstreetmap.gui.jmapviewer.events.*;
import org.openstreetmap.gui.jmapviewer.interfaces.*;
import org.openstreetmap.gui.jmapviewer.tilesources.*;
/**
 *
 */
@SuppressWarnings("serial")
public class MapaJogador extends JFrame implements JMapViewerEventListener,NodeConnectionListener/*,GroupMembershipListener*/
{
	private final JMapViewerTree treeMap;
	private JSpinner showhitpoints;

	private ArrayList<MapMarkerCircle> circulosZonas = new ArrayList<>();
	private double novoRaio = 9;
	private UUID uuid = UUID.randomUUID();
	public String username;    // sem usuario padrao pois nao ha verificacao no servidor

	private final static String        gatewayIP    = "127.0.0.1";
	private final static int           gatewayPort  = 5500;
	private final static InetSocketAddress address = new InetSocketAddress(gatewayIP, gatewayPort);
	public GroupCommunicationManager groupManager;
	public MrUdpNodeConnection connection;

	public MapaJogador(String username_){
		super("Mapa");
		username = username_;
		setSize(600,600);
		treeMap = new JMapViewerTree("Zonas");

		map().addJMVListener(this);

		setLayout(new BorderLayout());
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setExtendedState(JFrame.MAXIMIZED_BOTH);
		JPanel painel = new JPanel(new BorderLayout());
		JPanel painelTop = new JPanel();
		JPanel painelBot = new JPanel();
		JPanel painelAjuda = new JPanel();

		add(painel, BorderLayout.NORTH);
		add(painelAjuda, BorderLayout.SOUTH);
		painel.add(painelTop, BorderLayout.NORTH);
		painel.add(painelBot, BorderLayout.SOUTH);

		JLabel tituloAjuda = new JLabel("Scroll or double click zooms, right-click-and-drag moves the map.");
		painelAjuda.add(tituloAjuda);

		JButton botaoJogadores = new JButton("Redimensionar");
		botaoJogadores.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				map().setDisplayToFitMapMarkers();
			}
		});

		JComboBox<TileSource> tileSourceSelector = new JComboBox<>(new TileSource[] {
				new OsmTileSource.Mapnik(),
				new OsmTileSource.CycleMap(),
				new BingAerialTileSource(),
				new MapQuestOpenAerialTileSource(),
				new MapQuestOsmTileSource(),
		});
		tileSourceSelector.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(ItemEvent e) {
				map().setTileSource((TileSource) e.getItem());
			}
		});

		JComboBox<TileLoader> tileLoaderSelector;
		tileLoaderSelector = new JComboBox<>(new TileLoader[] {
				new OsmTileLoader(map())
		});
		tileLoaderSelector.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(ItemEvent e) {
				map().setTileLoader((TileLoader) e.getItem());
			}
		});
		map().setTileLoader((TileLoader) tileLoaderSelector.getSelectedItem());
		painelTop.add(tileSourceSelector);
		painelTop.add(tileLoaderSelector);

		final JCheckBox showTileGrid = new JCheckBox("Show Grid");
		showTileGrid.setSelected(map().isTileGridVisible());
		showTileGrid.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				map().setTileGridVisible(showTileGrid.isSelected());
			}
		});
		painelBot.add(showTileGrid);
		final JCheckBox showZoomControls = new JCheckBox("Show Zoom Controls");
		showZoomControls.setSelected(map().getZoomContolsVisible()); // BOGUS JMAPViEWER API VERSION Contols
		showZoomControls.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				map().setZoomContolsVisible(showZoomControls.isSelected());
			}
		});
		painelBot.add(showZoomControls);
		final JCheckBox scrollWrapEnabled = new JCheckBox("Scrollwrap enabled");
		scrollWrapEnabled.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				map().setScrollWrapEnabled(scrollWrapEnabled.isSelected());
			}
		});
		// DETECTAR MOUSE INPUT
		try {
			System.out.println("iniciar conexao");
			connection = new MrUdpNodeConnection();
			connection.addNodeConnectionListener(this);
			Thread.sleep(100);
			connection.connect(address);
		}catch (IOException e){e.printStackTrace();} catch (InterruptedException e) {
			e.printStackTrace();
		}
		System.out.println("terminar conexao");

		MouseListener mousePlayer = new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				if (!( e.getClickCount()==1 && e.getButton()==MouseEvent.BUTTON1 ))
					return;
				Coordinate c = map().getPosition( e.getPoint() );
				ZonaAtaque z = new ZonaAtaque(c.getLat(),c.getLon(),novoRaio,uuid,username);
				Message m = new ApplicationMessage();
				m.setContentObject( z );
				m.setSenderID(uuid);
				try{
					connection.sendMessage( m );
				}catch (IOException ignore){ignore.printStackTrace();}
				System.out.println("enviou z = " + z);
			}
		};
		map().addMouseListener(mousePlayer);

		JLabel tituloRaio = new JLabel(" Raio da sua zona (em Km):");
		JSpinner spinRaio = new JSpinner(new SpinnerNumberModel(1000,1,9999,1));
		spinRaio.addChangeListener(new ChangeListener() {
			@Override
			public void stateChanged(ChangeEvent e) {
				novoRaio = (Integer)spinRaio.getValue() * 360.0 / 40000.0;
			}
		});
		JLabel titulohitpoints = new JLabel("Seus Pontos:");
		showhitpoints = new JSpinner();
		showhitpoints.setPreferredSize( new Dimension(80,20) );
	//	showhitpoints.setEnabled(false);
		painelTop.add(titulohitpoints);
		painelTop.add(showhitpoints);

		painelTop.add(tituloRaio);
		painelTop.add(spinRaio);

		painelBot.add(scrollWrapEnabled);
		painelBot.add(botaoJogadores);

		add(treeMap, BorderLayout.CENTER);

		map().addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				if (e.getButton() == MouseEvent.BUTTON1) {
					map().getAttribution().handleAttribution(e.getPoint(), true);
				}
			}
			@Override
			public void mouseMoved(MouseEvent e) {
				Point p = e.getPoint();
				boolean cursorHand = map().getAttribution().handleAttributionCursor(p);
				if (cursorHand) {
					map().setCursor(new Cursor(Cursor.HAND_CURSOR));
				} else {
					map().setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
				}
			}
		} );

	}

	@Override
	public void processCommand(JMVCommandEvent command) {
		if (command.getCommand().equals(JMVCommandEvent.COMMAND.ZOOM) ||
				command.getCommand().equals(JMVCommandEvent.COMMAND.MOVE)) {
	//		updateZoomParameters();
		}
	}

	private JMapViewer map() { return treeMap.getViewer(); }

	public void incluiZona(ZonaAtaque zona) {
		MapMarkerCircle userc = new MapMarkerCircle(zona.getLat(),zona.getLon(),zona.getRaio());
		userc.setName( zona.getPlayer() );
		map().addMapMarker(userc);
		Iterator<MapMarkerCircle> i = circulosZonas.listIterator();
		while (i.hasNext()) {
			MapMarkerCircle c = i.next();
			if (c.getName().equals(zona.getPlayer()) ){
				i.remove();
				break;
			}
		}
		circulosZonas.add(userc);
	}

	public void removeZona(String nome){
		for (MapMarkerCircle c : circulosZonas){
			if( c.getName().equals( nome ) );
			map().removeMapMarker( c );
		}
	}

	public void refreshZonas(List<ZonaAtaque> listaZonas) {
		map().removeAllMapMarkers();
		for (ZonaAtaque zona : listaZonas){
			MapMarkerCircle circle = new MapMarkerCircle(zona.getPlayer(),
					new Coordinate(zona.lat,zona.lon),zona.getRaio());
			circle.setBackColor(new Color(50,0,0,100));
			map().addMapMarker(circle);
		}
	}

	@Override
	public void connected(NodeConnection nodeConnection) {
		System.out.println("connected");
		groupManager = new GroupCommunicationManager(nodeConnection);
	//	groupManager.addMembershipListener(this);
		ApplicationMessage m = new ApplicationMessage();
		m.setContentObject(username);
		m.setSenderID(uuid);
		try{
			nodeConnection.sendMessage(m);
		}catch (IOException e){e.printStackTrace();}
	//	System.out.println("group connected");
	}

	@Override
	public void reconnected(NodeConnection nodeConnection, SocketAddress socketAddress, boolean b, boolean b1) {
		System.out.println("reconnected");
	}

	@Override
	public void disconnected(NodeConnection nodeConnection) {
		System.out.println("disconnected");
	}

	@Override
	public void newMessageReceived(NodeConnection nodeConnection, Message message) {
		Serializable s = message.getContentObject();
		System.out.println("received ::: "+ s);
		try{
			if (s instanceof List) {
				LinkedList<ZonaAtaque> zlist = (LinkedList<ZonaAtaque>) s;
				ZonaAtaque z0 = zlist.getLast();

				Iterator<MapMarker> m_iter = map().getMapMarkerList().listIterator();
				while (m_iter.hasNext()){
					MapMarker m_n = m_iter.next();
					if(z0.contem(m_n.getLat(), m_n.getLon()) ){
						m_iter.remove();
					} else {
						((MapMarkerCircle)m_n).setBackColor(new Color(40,40,40,60) );
					}
				}
				for (ZonaAtaque z : zlist){
					Iterator<MapMarker> mlist_2_it = map().getMapMarkerList().listIterator();
					while (mlist_2_it.hasNext() ){
						MapMarker m_next = mlist_2_it.next();
						if( m_next.getName().equals(z.getPlayer() ) ){
							map().removeMapMarker(m_next);
							break;
						}
					}
					MapMarkerCircle zc = new MapMarkerCircle(z.getLat(),z.getLon(),z.getRaio());
					zc.setName(z.getPlayer() );
					map().addMapMarker(zc );
					if(z.getPlayer().equals(username) ){
						showhitpoints.setValue(z.pontos);
					}
				}
			} else if (s instanceof ZonaAtaque){
				ZonaAtaque z = (ZonaAtaque) s;
				Iterator<MapMarker> itC = map().getMapMarkerList().iterator();
				while (itC.hasNext()){
					MapMarkerCircle circle = (MapMarkerCircle) itC.next();
					if (circle.getName().equals( z.getPlayer() ) )
						itC.remove();
					//	map().removeMapMarker(circle);
				}
				MapMarkerCircle zc = new MapMarkerCircle(z.getLat(),z.getLon(),z.getRaio());
				zc.setName(z.getPlayer() );
				zc.setBackColor(new Color(200,100,100,40));
				map().addMapMarker(zc );
				if(z.getPlayer().equals(username) ){
					showhitpoints.setValue(z.pontos);
				}
			} else if (s instanceof Integer){
				showhitpoints.setValue( (Integer) s );
			}
		}catch (ClassCastException e){e.printStackTrace();}
	}

	@Override
	public void unsentMessages(NodeConnection nodeConnection, List<Message> list) {}

	@Override
	public void internalException(NodeConnection nodeConnection, Exception e) {}

//	@Override
//	public void enteringGroups(List<Group> list) {}

//	@Override
//	public void leavingGroups(List<Group> list) {}

	public static void main(String[] args) {
		BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
		try {
			String player = "";
			while (player.equals("")){
				System.out.print("Entre com o nome do jogador : ");
				player = input.readLine();
			}
			MapaJogador mapa = new MapaJogador( player );
			mapa.setVisible(true);

			while (true) try{
				Thread.sleep(Integer.MAX_VALUE);
			}catch (InterruptedException e){
				e.printStackTrace();
			}
		} catch (IOException e) { e.printStackTrace(); }
	}
};
