
local group = {}

local function grp_key(grptype, id)
   return tostring(grptype)..","..tostring(id)
end

local mt = {
   __eq = function(a, b)
      return (a.type == b.type and a.id == b.id)
   end,
   __lt = function(a, b)
      return (a.type < b.type) or (a.type == b.type and a.id < b.id)
   end,
   __tostring = function(self)
      return "Group("..grp_key(self.type, self.id)..")"
   end
}

local pool = {}
setmetatable(pool, {__mode = "v"})

group.new = function(grptype, id)
   local key = grp_key(grptype, id)
   if pool[key] then
      return pool[key]
   end
   local self = {
      is_grp = true,
      type = grptype,
      id = id,
   }
   setmetatable(self, mt)
   pool[key] = self
   return self
end

return group
