
local logging = require("logging")
logging.console = require("logging.console")
local dispatcher = require("lac.dispatcher")
local node = require("lac.clientlib.mrudp.node")
local messages = require("lac.clientlib.messages")
local javaserialize = require("javaserialize")

-- local tests = require("lac.mrudp.tests")
-- tests.log_packets_to_stdout = true

local disp = dispatcher.new()

local ImageIcon = {
   __name = "javax.swing.ImageIcon",
   __serialVersionUID = string.char(0xF2, 0xA6, 0x35, 0x6E, 0xDE, 0x0C, 0x0E, 0x32),
   __flags = { serializable = true, write_method = true },
   [1] = { "int", "height" },
   [2] = { "int", "width" },
   [3] = { "javax.swing.ImageIcon$AccessibleImageIcon", "accessibleContext" },
   [4] = { "String", "description" },
   [5] = { "java.awt.image.ImageObserver", "imageObserver" },
}

local CustomData = {
   __name = "lac.cnclib.helloworld.CustomData",
   __serialVersionUID = string.char(0x54, 0x8F, 0x7D, 0x57, 0xF7, 0x2B, 0x88, 0xF6),
   [1] = { "String", "caption" },
   [2] = { ImageIcon, "icon" },
}

local IntArray = {
   __name = "int[]",
   __serialVersionUID = string.char(0x4D, 0xBA, 0x60, 0x26, 0x76, 0xEA, 0xB2, 0xA5),
}

local function load_image(filename)
   local image = {}
   local fd = io.open(filename, "r")
   if not fd then return nil, "could not open "..filename end
   local format = fd:read("*l")
   if format ~= "P6" then return nil, "unrecognized format, expected PNM file" end
   local size = fd:read("*l")
   local width, height = size:match("(%d+) (%d+)")
   if not height then return nil, "could not read dimensions -- corrupted file?" end
   width, height = tonumber(width), tonumber(height)
   local depth = fd:read("*l")
   if depth ~= "255" then return nil, "unrecognized color depth, expected 24-bit PNM file" end
   for i = 1, width*height do
      local bytes = fd:read(3)
      if not bytes then return nil, "failed reading data -- corrupted file?" end
      local r, g, b = string.byte(bytes, 1, 3)
      image[i] = 0xff000000 + (r * 2^16) + (g * 2^8) + b
   end
   fd:close()
   return image, width, height
end

local function send_icon(connection, filename, caption)

   local image, width, height = load_image(filename)
   if not image then
      print(width)
      connection:disconnect()
      return nil
   end

   local cd = {
      caption = caption,
      icon = {
         height = height,
         width = width,
         accessibleContext = javaserialize.null,
         description = "file:/"..filename, --"file:/Users/hisham/work/mr-udp/ContextNet/ClientLib/build/lac/cnclib/helloworld/logo.gif",
         imageObserver = javaserialize.null,
         __annotations = {
            { __kind = "blockdata", javaserialize.toint(width) .. javaserialize.toint(height) }
         },
         __write = function(w)
            image.__class = IntArray
            w:newArray(image)
         end,
      }
   }
   
   local imgMsg = messages.new()
   imgMsg:set_content_java_obj(cd, CustomData)
   connection:send_message(imgMsg)
   return true
end

function main()
   
   local logger = logging.console()
   logger:setLevel(logging.DEBUG)
   
   local connection = node.new(disp, nil, nil, nil, logger)
   
   connection:connect("127.0.0.1", 5500)
   
   disp:sleep(1)
   
   local textMsg = messages.new()
   textMsg:set_content_java_obj("Hello World Title :-)")
   connection:send_message(textMsg)

   disp:sleep(1)
   
   local ok

   --[[
   ok = send_icon(connection, "lac/clientlib/tests/helloworld/logo.pnm", "LAC")
   if not ok then return end
   ]]

   ok = send_icon(connection, "lac/clientlib/tests/helloworld/lua.pnm", "LabLua")
   if not ok then return end
   
   disp:sleep(5)
   
   connection:disconnect()
   
   disp:sleep(3)

end

disp:start(main)
