
local pb = require("pb")
local parser = require("pb.proto.parser")
local utils = require("lac.clientlib.pb_utils")

pb.path = pb.path .. ";./lac/clientlib/?.proto;"

local proto = pb.require("lac.clientlib.protocol.protocol")
print("Valid .proto file")

local function print_bytes(bytes, err)
   if bytes then
      print(#bytes, "bytes")
   else
      print("Error:", err)
   end
end

-------------------------------------------------------------------------------
for k,v in pairs(proto.ClientLibMessage) do
   print(k, v)
end

local msg = proto.ClientLibMessage({
   msgType = proto.MSGType.APPLICATION,
   contentPayload = "1",
})

print(msg)

local bytes, err = msg:Serialize()
print_bytes(bytes, err)


local msg2 = proto.ClientLibMessage()
print( msg2:Parse(bytes) )

print("msg", msg.msgType, msg.contentPayload)
print("msg2", msg2.msgType, msg2.contentPayload)
-------------------------------------------------------------------------------
local group_membership_message = pb.require("lac.clientlib.protocol.group_membership_message")

local gm = group_membership_message.GroupMembership {
   groupsJoined = {
      proto.Group { groupType = 1, groupID = 10 },
      proto.Group { groupType = 2, groupID = 20 },
      proto.Group { groupType = 3, groupID = 30 },
   },
   groupsLeft = {
      proto.Group { groupType = 4, groupID = 40 },
      proto.Group { groupType = 5, groupID = 50 },
   },
}

local gmm = proto.ClientLibMessage {
   msgType = proto.MSGType.GROUPMEMBERSHIP,
   contentPayload = gm:Serialize(),
}

local bytes, err = gmm:Serialize()
print_bytes(bytes, err)

local gmm2 = proto.ClientLibMessage()
gmm2:Parse(bytes)

local gm2 = group_membership_message.GroupMembership()
gm2:Parse(gmm2.contentPayload)

for k,v in ipairs(gm2.groupsJoined) do
   print(k,v.groupType, v.groupID)
end

print(#gmm2.contentPayload)
-------------------------------------------------------------------------------

