
local logging = require("logging")
logging.console = require("logging.console")
local dispatcher = require("lac.dispatcher")
local node = require("lac.clientlib.mrudp.node")
local messages = require("lac.clientlib.messages")
local javaserialize = require("javaserialize")

-- local tests = require("lac.mrudp.tests")
-- tests.log_packets_to_stdout = true

local disp = dispatcher.new()

-- Quick deseralization of a Java string.
-- You should not be sending Java objects over, you should be
-- sending raw byte arrays (which are naturally converted to
-- strings in Lua, and can be easily converted to String objects
-- in Java).
local function quick_n_dirty_string_deserialize(bytes)
   -- STREAM_MAGIC
   if bytes:sub(1,2) ~= "\172\237" then return nil, "not Java!" end
   -- STREAM_VERSION
   if bytes:sub(3,4) ~= "\0\5" then return nil, "incompatible Java stream!" end
   -- TC_STRING
   if bytes:sub(5,5) ~= "t" then return nil, "not a string!" end
   local lenmsb, lenlsb = bytes:byte(6,7)
   local len = tonumber(lenmsb) * 255 + tonumber(lenlsb)
   local str = bytes:sub(8)
   if #str ~= len then return nil, "invalid length! corrupted data?" end
   return str
end

local listener = {
   new_message_received = function(your_app_obj, node, msg)
      print("message received!", your_app_obj, node, msg)
      print("got a Java object with "..tostring(#msg.content).." bytes")
      local str, err = quick_n_dirty_string_deserialize(msg.content)
      if str then
         print("It's a Java string!")
         print(str)
      else
         print(err)
      end
   end
}

function main()
   
   local logger = logging.console()
   logger:setLevel(logging.DEBUG)
   
   local connection = node.new(disp, nil, nil, nil, logger)
   
   connection:connect("127.0.0.1", 5500)
   
   disp:sleep(1)
   
   local textMsg = messages.new()
   textMsg:set_content_java_obj("Hello World Title :-)")
   connection:send_message(textMsg)
   
   connection:add_listener("external", listener, "an app object")

   disp:sleep(1)
   
   connection:disconnect()
   
   disp:sleep(1)

end

disp:start(main)
