
local tests = {}

local socket = require("socket")

tests.lose_packets = false
tests.packet_loss_percent = 0
tests.log_packets_to_file = false
tests.log_packets_to_stdout = false

setmetatable(tests, {
   __gc = function(tests)
      if tests.packet_log_fd then
         print("Saved packet log to "..tests.packet_log_name)
         tests.packet_log_fd:close()
      end
   end,
})

function tests.open_packet_log()
   if not tests.packet_log_fd then
      local getpid = io.popen("echo $$")
      local pid = getpid:read("*a"):gsub("\n", "")
      getpid:close()
      tests.packet_log_name = "packets-"..pid..".log"
      tests.packet_log_fd = io.open(tests.packet_log_name , "w")
      print("Logging packets to "..tests.packet_log_name )
   end
end

function tests.log_packet(seg, mode)
   if tests.log_packets_to_file or tests.log_packets_to_stdout then
      local msg = socket.gettime().."\t"..mode.." "..seg:tostring():gsub("[^%[]+%[", "[").."\n"
      if tests.log_packets_to_stdout then
         print(msg)
      elseif tests.log_packets_to_file then
         tests.open_packet_log()
         tests.packet_log_fd:write(msg)
         tests.packet_log_fd:flush()
      end
   end
end

return tests
