
local mrudp = require("lac.mrudp")
local dispatcher = require("lac.dispatcher")
local md5 = require("md5")
local disp = dispatcher.new()

local tests = require("lac.mrudp.tests")
tests.lose_packets = true
tests.packet_loss_percent = 20
tests.log_packets_to_stdout = true

function main()
   local serverskt = mrudp.server_socket(disp, 10341)
   local connskt, err = serverskt:accept()
   if not connskt then
      print(err)
   else
      local large = connskt:receive("*a")
      print("********** size of large file received: ", #large)
      print("********** MD5 of large file received:", md5.sumhexa(large))
      local fd = io.open("file.dat", "w")
      fd:write(large)
      fd:close()
   end
   serverskt:close()
end

disp:start(main)
