local arg = {...}

local mrudp = require("lac.mrudp")
local dispatcher = require("lac.dispatcher")
local md5 = require("md5")

local disp = dispatcher.new()

local tests = require("lac.mrudp.tests")
tests.log_packets_to_stdout = true

--collectgarbage("stop")

function main()
   disp:set_thread_name("ps_client")
   
   local mainskt, err = mrudp.client_socket(disp, "127.0.0.1", 10341)
   if err then
      print("Client socket error: ", err)
      return
   end

   local n = arg[1] or 50
   local size = tonumber(arg[2]) or 200
   assert(mainskt:send(n..","..size.."\n"))
   mainskt:flush()
   n = tonumber(n)
   
   local ok, err = mainskt:receive("*l")
   if not ok then
      print("send error:", err)
      return
   end
   print("Received: ", ok)
      
   local clients = {}
   
   local sent = 0
   local joiner = {}
   
   for i = 1, n do
      local client = {}
      clients[i] = client
      coroutine.wrap(function(client, i)
         disp:set_thread_name("ps_tx_"..i)
         client.skt, err = mrudp.client_socket(disp, "127.0.0.1", 10341)
         if not client.skt then
            print("Failed connecting")
            return
         end
         print("Client "..i.." connected. Will wait...")
         disp:sleep(1)
         print("Will send...")
         client.msg = string.char(32+(i%200)):rep(size)

         -- client.skt:send(client.msg)
         local total = 0
         local msg = client.msg
         while total < #msg do
            local ok, err, done = client.skt:send(msg, total + 1, total + 10000)
            if ok then
               done = ok 
               client.skt:flush()
            else
               print("********** ERROR: ", err)
               if err == "closed" or err == "eof" then
                  break
               end
            end
            total = total + done
         end

         client.skt:flush()
         sent = sent + 1
         print("Client "..i.." sent. Will notify...")
         disp:enqueue(joiner)
         client.skt:close()
         print("Client "..i.." gone.")
      end)(client, i)
   end
   
   while sent < n do
      print("Clients sent:", sent)
      disp:wait(joiner)
   end
   
   print("All sent!")
   
   for i, client in ipairs(clients) do
      print(i, md5.sumhexa(client.msg))
   end

   mainskt:close()

end

disp:start(main)
