
local mrudp = require("lac.mrudp")
local dispatcher = require("lac.dispatcher")
local uuid = require("uuid")

local tests = require("lac.mrudp.tests")
tests.log_packets_to_stdout = true

print("Tests 07 and 08. Callbacks - client")

function main(disp)

   local clientskt, err = mrudp.client_socket(disp, "127.0.0.1", 10341)
   if err then
      print(err)
      return
   end

   print("remote endpoint", clientskt.host, clientskt.port)
   print("local address", clientskt.skt:getsockname() )
   clientskt:set_uuid(uuid.new())

   clientskt:add_listener({

      packet_received_in_order = function()
         print("Client: Packet received in order!")
         local data, err = clientskt:receive("*l")
         if data then
            print("Client: Received:", data)
         else
            print("Client: Error:", err)
         end               
      end,

      packet_received_out_of_order = function()
         print("Client: Packet received out of order!")
      end,
      
      connection_closed = function()
         print("Client: Connection closed callback!")
      end,

      connection_failure = function()
         print("Client: Connection failure callback!")
      end,
      
   })

   for i = 1, 10 do
      clientskt:send("hello "..i.."\n")
      disp:sleep(5)
   end
   clientskt:close()

end

local disp = dispatcher.new()
disp:start(main)
