
local mutex = {}

local function mutex_lock(self)
   local my_handle = {}
   while self.is_locked do
      table.insert(self.queue, my_handle)
      self.scheduler:wait(my_handle)
   end
   self.is_locked = true
end

local function mutex_unlock(self)
   self.is_locked = false
   if #self.queue > 0 then
      local next_handle = table.remove(self.queue, 1)
      self.scheduler:notify(next_handle)
   end
end

function mutex.new(scheduler)
   local self = {
      scheduler = scheduler,
      queue = {},
      is_locked = false,
      lock = mutex_lock,
      unlock = mutex_unlock,
   }
   return self
end

return mutex
