
local dispatcher = require("lac.dispatcher")

local main = function(scheduler)

print("0 init")
print("0 will wait alone for 2 s...")
scheduler:wait("lock0", 2)

coroutine.wrap(function()
   print("1 init", "lock1")
   print("1 will wait 15 s...")
   local msg = scheduler:wait("lock1", 15)
   print("1 got:", msg)
   print("1 done")
end)()
print("0 after 1")

coroutine.wrap(function()
   print("2 init", "lock2")
   print("2 will wait 1 s...")
   local ok, err = scheduler:wait("lock2", 1)
   print("2 got timeout as expected?", err == "timeout")
   print("2 notifying 0...")
   local ok, err = scheduler:notify("lock0", "get back to work 0, it's 2!")
   if not ok then print(err) end
   print("2 will wait for a msg...")
   msg, err = scheduler:wait("lock2")
   print("2 got:", msg)
   print("2 notifying 3...")
   local ok, err = scheduler:notify("lock3", "wake up 3, it's 2!")
   if not ok then print(err) end
   print("2 done")
end)()
print("0 after 2")

print("0 waiting...")
local msg = scheduler:wait("lock0", 4)
print("0 got: "..msg)

coroutine.wrap(function()
   print("3 init", "lock3")
   print("3 waiting...")
   local msg = scheduler:wait("lock3")
   print("3 got:", msg)
   print("3 waiting again...")
   local msg = scheduler:wait("lock3")
   print("3 got:", msg)
   print("3 done")
end)()
print("0 after 3")

print("0 notifying...")
scheduler:notify("lock3", "0 waking up 3!")

coroutine.wrap(function()
   print("4 init", "lock4")
   print("4 will wait 2.5...")
   local ok, err = scheduler:wait("lock4", 3.5)
   print("4 got timeout as expected?", err == "timeout")
   print("4 notifying 1...")
   local ok, err = scheduler:notify("lock1", "wake up 1, it's 4!")
   if not ok then print(err) end
   print("4 notifying 2...")
   local ok, err = scheduler:notify("lock2", "hey 2, it's 4... go and wake up 3!")
   if not ok then print(err) end
   print("4 done")
end)()
print("0 after 4")

print("0 done")

end

local disp = dispatcher.new()
disp:start(main)
