
local timer = require("lac.timer")
local dispatcher = require("lac.dispatcher")
local socket = require("socket")

function main(dispatcher)
   
   local start = socket.gettime()
   local function now() return socket.gettime() - start end
   
   local t1 = timer.new(dispatcher, "t1", function()
      print("timer 1", now())
   end)
   
   local t2 = timer.new(dispatcher, "t2", function()
      print("timer 2", now())
   end)
   
   t1:schedule(2, 2)
   
   t2:schedule(0, 3)

   n = 5
   print("And now, "..n.." seconds of t1 and t2...")
   
   dispatcher:wait({}, n)
   
   print("killing everyone in 5 seconds...")
   
   local i = 5
   timer.new(dispatcher, "killer", function(self)
      print("killer is ", coroutine.running())
      if i > 0 then
         print("Killing in "..i.."...")
         i = i - 1
      else
         print(i, "Bye bye!")
         t1:cancel()
         t2:cancel()
         print("canceling self...")
         self:cancel()
         dispatcher:notify("end_phase_1")
      end
   end):schedule(1, 1)
   
   dispatcher:wait("end_phase_1")
   print("End of phase 1!")
   
   local t3 = timer.new(dispatcher,  "t3", function()
      print("timer 3", socket.gettime() - start)
   end)
   
   print("now is", now(), "- scheduling t3 for ", now() + 10)
   t3:schedule(10, 10)
   
   dispatcher:wait({}, 5)
   print("now is", now(), "- resetting t3")
   t3:reset()
   
   dispatcher:wait({}, 12)
   print("ok, cancelling t3")
   t3:cancel()
   
end

local disp = dispatcher.new()
disp:start(main)
