
local reader = {}

local messages = require("lac.clientlib.messages")
local serialization = require("lac.clientlib.serialization")

local Reader = {}

function Reader:reset()
   self.buf = {}
   self.buf_len = 0
   self.pipe1 = nil
   self.pipe2 = nil
end

local function handle_ping(self, msg)
   local ping = msg:get_content_obj()
   -- MrUdpPassiveReader:237
   if not ping.pong then
      ping.pong = true
      -- msg:set_content_obj(ping)
      self.node:send_message(msg)
   end
   self.node:inform_listeners("sddl", "ping_received", ping)
end

local function handle_handover(self, msg)
   local poa_list = msg:get_content_obj()
   self.node:inform_listeners("sddl", "new_point_of_attachment_list_received", poa_list)
   self.node.poa = poa_list
   if poa_list.switch_gw == 1 then
      self.node:start_handover(false, true)
   end
end

local function handle_extended_msg(self, msg)
   self.node:inform_advanced_listeners("new_protocol_message_received", msg.type, msg)
end

local function handle_application(self, msg)
   self.node:inform_listeners("external", "new_message_received", msg)
end

local function process_obj(self, msg)
   if msg.type == messages.types.APPLICATION then
      handle_application(self, msg)
   elseif msg.type == messages.types.GROUPMEMBERSHIP then
      handle_extended_msg(self, msg)
   elseif msg.type == messages.types.GROUPCAST then
      handle_extended_msg(self, msg)
   elseif msg.type == messages.types.PING then
      handle_ping(self, msg)
   elseif msg.type == messages.types.POA then
      handle_handover(self, msg)
   else
      handle_application(self, msg)
   end
end

local function process_buffer(self)
   if not self.pipe2 then
      for i, part in ipairs(self.buf) do
         local found = part:find("|", 1, true)
         if found then
            if self.pipe1 then
               self.pipe2 = found
               break
            else
               self.pipe1 = found
            end
            found = part:find("|", found+1, true)
            if found then
               self.pipe2 = found
               break
            end
         end
      end
   end

   if self.pipe2 then
      local buf = table.concat(self.buf)
      local class_name_size = tonumber(buf:sub(1, self.pipe1 - 1))
      local obj_size = tonumber(buf:sub(self.pipe1 + 1, self.pipe2 - 1))
      local offset = self.pipe2 + 1

      if self.buf_len - (offset - 1) == obj_size + class_name_size then
         local obj_start = offset + class_name_size
         self.class_name = buf:sub(offset, obj_start - 1)
         local obj_buf = buf:sub(obj_start)
         local obj = serialization.from_protocol_msg(obj_buf)
         local ok = process_obj(self, obj)
         if not ok then
            self.node:inform_listeners("external", "internal_exception")
         end
         self:reset()
      end
   end
end

local packet_sent = function(self, clientskt)
   self.node:debug("packet sent")
end

local packet_received_in_order = function(self, clientskt, reader)
   local data, err = clientskt:receive("*b")
   if not data then
      self.node:fail("error reading - "..self.node.uuid)
      self.node:inform_listeners("external", "internal_exception")
      return
   end
   table.insert(self.buf, data)
   self.buf_len = self.buf_len + #data
   process_buffer(self)
end

local ack_received = function(self, clientskt, ackn)
   local looped = false
   if ackn < self.last_ack then
      looped = true
   end
   last_ack = ackn
   while true do
      local sentobj = self.node.sent_objects[1]
      if not sentobj or sentobj.seqn < 0 then
         break
      end
      local check = true
      if looped then
         if sentobj.seqn > ackn then
            table.remove(self.node.sent_objects, 1)
            check = false
         else
            looped = false
         end
      end
      if check then
         if sentobj.seqn <= ackn then
            table.remove(self.node.sent_objects, 1)
         else
            break
         end
      end
   end
   looped = false
end

function reader.get_listener(node)
   local obj = {

      node = node,
      reset = Reader.reset,
      
      -- This can't be right, but let's copy the Java implementation...
      last_ack = 0,

      packet_sent = packet_sent,
      packet_received_in_order = packet_received_in_order,
      ack_received = ack_received,

      packet_retransmitted = nil,
      packet_received_out_of_order = nil,

   }
   obj:reset()
   return obj
end

return reader
