
local sched = require("lac.dispatcher")
local mrudp_node = require("lac.clientlib.mrudp.node")
local groups_mgr = require("lac.clientlib.groups.manager")

local tests = {

   function()
   
      local node = mrudp_node.new(sched)
      local mgr = groups_mgr.new(node)
      
      assert(mgr)
   end,

}

local passed, failed = 0, 0
for i = 1, #tests do
   local ok, err = xpcall(tests[i], function(err) print(debug.traceback(err, 2)) end)
   if ok then
      print("OK")
      passed = passed + 1
   else
      print("fail:", err)
      failed = failed + 1
   end
   print("----------------------------------------")
end
print()
print("Total: "..passed.." test"..(passed == 1 and "" or "s").." passed. "..failed.." test"..(failed == 1 and "" or "s").." failed.")

