
local messages = require("lac.clientlib.messages")
local serialization = require("lac.clientlib.serialization")
local uuid = require("uuid")

local pb = require("pb")
local proto = pb.require("lac.clientlib.protocol.protocol")

---
-- next tests:
local pubsub_mgr = require("lac.clientlib.pubsub.manager")
local groups_mgr = require("lac.clientlib.groups.manager")
local reader = require("lac.clientlib.mrudp.reader")
local config = require("lac.clientlib.mrudp.config")
local node = require("lac.clientlib.mrudp.node")
---

local tests = {
   function()
      local msg = messages.new()
      print(msg:tostring())
      assert(msg.type == proto.MSGType.APPLICATION)
   end,

   function()
      local msg1 = messages.new()
      local bytes = serialization.to_protocol_msg(msg1)
      print("msg1", msg1:tostring())
      local msg2 = serialization.from_protocol_msg(bytes)
      print("msg2", msg2:tostring())
      assert(msg1.type == proto.MSGType.APPLICATION)
      assert(msg2.type == proto.MSGType.APPLICATION)
   end,

   -- Tags   
   function()
      local msg1 = messages.new()
      msg1:add_tag("hello")
      msg1:add_tag("world")
      assert(msg1:index_of_tag("world") == 2)
      assert(msg1:index_of_tag("hello") == 1)
      assert(msg1:has_tag("hello"))
      assert(not msg1:has_tag("goodbye"))
      msg1:remove_tag("hello")
      assert(not msg1:has_tag("hello"))
      assert(msg1:index_of_tag("world") == 1)
   end,

   -- Content Lua object
   function()
      local msg1 = messages.new()
      msg1:set_content_lua_obj("hello")
      local obj = msg1:get_content_obj()
      assert(obj == "hello")
      assert(#msg1.content == 5) -- serialized object
      local bytes = serialization.to_protocol_msg(msg1)
      local msg2 = serialization.from_protocol_msg(bytes)
      assert(msg2.content == msg1.content)
   end,

   -- Content Java object String
   function()
      local msg1 = messages.new()
      msg1:set_content_java_obj("hello")
      local obj = msg1:get_content_obj()
      assert(#msg1.content == 12) -- serialized object
      local bytes = serialization.to_protocol_msg(msg1)
      local msg2 = serialization.from_protocol_msg(bytes)
      assert(msg2.content == msg1.content)
   end,

   -- Content Java object class
   function()
   
      local FakeClass = {
         __name = "lac.cnclib.tests.modules.FakeClass",
         __serialVersionUID = string.char(0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07),
         [1] = { "String", "myField" },
      }

   
      local msg1 = messages.new()
      local fc = {
         myField = "hello, world!"
      }
      msg1:set_content_java_obj(fc, FakeClass)
      local obj = msg1:get_content_obj()
      local bytes = serialization.to_protocol_msg(msg1)
      local msg2 = serialization.from_protocol_msg(bytes)
      assert(msg2.content == msg1.content)
   end,

   function()
      local msg = messages.new_service()
      assert(msg.is_service)
   end,

   function()
      local msg1 = messages.new_pubsub(uuid.new(), "myinfoclass", "mymainvalue")

      local bytes = serialization.to_protocol_msg(msg1)
      print("msg1", msg1:tostring())
      local msg2 = serialization.from_protocol_msg(bytes)
      print("msg2", msg2:tostring(), msg2.properties)
      
      print(msg1.properties["creationTime"])
      print(msg2.properties["creationTime"])

      assert(msg1.type == proto.MSGType.PUBSUBEVENT)
      assert(msg2.type == proto.MSGType.PUBSUBEVENT)
      assert(msg1 == msg2)
   end,

}

local passed, failed = 0, 0
for i = 1, #tests do
   local ok, err = xpcall(tests[i], function(err) print(debug.traceback(err, 2)) end)
   if ok then
      print("OK")
      passed = passed + 1
   else
      print("fail:", err)
      failed = failed + 1
   end
   print("----------------------------------------")
end
print()
print("Total: "..passed.." test"..(passed == 1 and "" or "s").." passed. "..failed.." test"..(failed == 1 and "" or "s").." failed.")

