-- imports
local logging = require("logging")
logging.console = require("logging.console")
local dispatcher = require("lac.dispatcher")
local node = require("lac.clientlib.mrudp.node")
local messages = require("lac.clientlib.messages")
local javaserialize = require("javaserialize")

local disp = dispatcher.new()

local applistener = {
   new_message_received = function(msg)
      print(msg)
   end,

   connected = function()
	  print("Abriu Conexao")
   end,

   reconnected = function()
      -- todo
   end,

   disconnected = function(node)
      -- todo
   end,

}

function main()
	local logger = logging.console()
	logger:setLevel(logging.DEBUG)

	local connection = node.new(disp, nil, nil, nil, logger)
	connection:add_listener("external", applistener)
	connection:connect("127.0.0.1", 5500)

	disp:sleep(1)
	for i = 1, 5 do
		local textMsg = messages.new()
		textMsg:set_content_java_obj("Mensagem para o primeiro gateway " .. i)
		connection:send_message(textMsg)
		disp:sleep(10)
	end

	disp:sleep(40)

	for i = 6, 10 do
		local textMsg = messages.new()
		textMsg:set_content_java_obj("Mensagem para o gateway secundario " .. i)
		connection:send_message(textMsg)
		disp:sleep(10)
	end

	disp:sleep(70)

end

disp:start(main)