
local mrudp = require("lac.mrudp")
local dispatcher = require("lac.dispatcher")
local uuid = require("uuid")

local tests = require("lac.mrudp.tests")
tests.log_packets_to_stdout = true

print("Test 01. UID segments - client")

function main(dispatcher)

   local clientskt, err = mrudp.client_socket(dispatcher, "127.0.0.1", 10341)
   if err then
      print(err)
   else
      print("remote endpoint", clientskt.host, clientskt.port)
      print("local address", clientskt.skt:getsockname() )
      clientskt:set_uuid(uuid.new())
      dispatcher:sleep(60)
      clientskt:close()
   end

end

local disp = dispatcher.new()
disp:start(main)
