local arg = {...}

local mrudp = require("lac.mrudp")
local dispatcher = require("lac.dispatcher")
local md5 = require("md5")

local tests = require("lac.mrudp.tests")
tests.lose_packets = true
tests.packet_loss_percent = 20

local disp = dispatcher.new()

function main()
   local clientskt, err = mrudp.client_socket(disp, "127.0.0.1", 10341)
   if err then
      print(err)
   else
      local buffer = {}
      for i = 1, 150000 do
         buffer[#buffer+1] = string.char(math.random(0,255))
      end
      local large = table.concat(buffer)
      local total = 0
      while total < #large do
         local ok, err, done = clientskt:send(large, total + 1, total + 10000)
         if ok then
            done = ok 
            clientskt:flush()
         else
            print("********** ERROR: ", err)
            if err == "closed" or err == "eof" then
               break
            end
         end
         total = total + done
      end
      clientskt:flush()
      clientskt:close()
      print("********** size of large file sent: ", #large)
      print("********** MD5 of large file sent: ", md5.sumhexa(large))
      print("********** total actually sent: ", total)
      print("********** MD5 of total sent: ", md5.sumhexa(large:sub(1,total)))
   end
end

disp:start(main)
