
local mrudp = require("lac.mrudp")
local dispatcher = require("lac.dispatcher")
local md5 = require("md5")
local disp = dispatcher.new()

local colors = require("ansicolors")

local tests = require("lac.mrudp.tests")
tests.log_packets_to_stdout = true

function main()

   disp:set_thread_name("ps_server")

   local serverskt = mrudp.server_socket(disp, 10341)

   local connskt, err = serverskt:accept()
   if not connskt then
      print("Server socket error: ", err)
      return
   end

   local msg, err = connskt:receive("*l")
   if not msg then
      print("receive error:", err)
      return
   end
   local count, size = msg:match("(%d+),(%d+)")
   count = tonumber(count)
   size = tonumber(size)
   print("Received: ", count, size)
   connskt:send("go!\n")

   local received = 0
   local joiner = {}
   
   local clients = {}
   local i = 1
   while #clients < count do
      local clientskt, err = serverskt:accept()
      if not clientskt then
         print(err)
      else
         local client = {
            skt = clientskt
         }
         clients[i] = client
         coroutine.wrap(function(client, i)
            disp:set_thread_name("ps_rx_"..i..":"..client.skt.port)

            --local data, err = client.skt:receive("*a")
            local total = 0
            local data = ""
            while total < size do
            print(colors("%{bright green}Receiving "..(size-total).." bytes..."))
               local chunk, err, rest = client.skt:receive(size - total)
               if chunk then
                  data = data .. chunk
                  total = total + #chunk
               else
                  print("********** ERROR: ", err)
                  if err == "closed" or err == "eof" then
                     if rest then
                        data = data .. rest
                     end
                  end
                  break
               end
            end

            print(colors("%{bright green}Server "..i.." received."))
            client.msg = data
            if data then
               client.ok = true
               client.skt:flush()
               print(colors("%{bright yellow}Server "..i.." flushed. Got "..#data.." bytes"))
            else
               print(colors("%{bright yellow}Client error:"), err)
            end
            client.skt:close()
            received = received + 1
            disp:enqueue(joiner)
            print(colors("%{bright yellow}Server "..i.." gone."))
         end)(client, i)
         i = i + 1
      end
   end
   
   while received < count do
      print(colors("%{bright red}Clients received:"), received)
      disp:wait(joiner)
   end
   
   print(colors("%{bright white greenbg}All received!"))
   
   for i, client in ipairs(clients) do
      print(i, #client.msg, md5.sumhexa(client.msg), client.ok and "ok" or "")
   end
   
   serverskt:close()
end

disp:start(main)
