local arg = {...}

local mrudp = require("lac.mrudp")
local dispatcher = require("lac.dispatcher")
local md5 = require("md5")

local disp = dispatcher.new()

function main()
   local clientskt, err = mrudp.client_socket(disp, "127.0.0.1", 10341)
   if err then
      print(err)
   else
      local buffer = {}
      if arg[1] == "pattern" then
         local c = 0
         for i = 1, 500 do
            local num = "\n" .. tostring(i) .. "*"
            buffer[#buffer+1] = num .. string.rep(string.char(48+c), 1000 - #num)
            c = c + 1
            if c == 10 then c = 0 end
         end
      else
         for i = 1, 500000 do
            buffer[#buffer+1] = string.char(math.random(0,255))
         end
      end
      local large = table.concat(buffer)
      local total = 0
      while total < #large do
         local ok, err, done = clientskt:send(large, total + 1, total + 10000)
         if ok then
            done = ok 
            clientskt:flush()
         else
            print("********** ERROR: ", err)
            if err == "closed" or err == "eof" then
               break
            end
         end
         total = total + done
      end
      clientskt:flush()
      clientskt:close()
      print("********** size of large file sent: ", #large)
      print("********** MD5 of large file sent: ", md5.sumhexa(large))
      print("********** total actually sent: ", total)
      print("********** MD5 of total sent: ", md5.sumhexa(large:sub(1,total)))
   end
end

disp:start(main)
