
local mrudp = require("lac.mrudp")
local dispatcher = require("lac.dispatcher")

local tests = require("lac.mrudp.tests")
tests.log_packets_to_stdout = true

print("Tests 07 and 08. Callbacks - server")

local join = {}

function main(disp)
   local serverskt = mrudp.server_socket(disp, 10341)
   local connskt, err = serverskt:accept()
   if not connskt then
      print(err)
      serverskt:close()
      return
   end
   print("Got connection!")
   
   connskt:add_listener({

      packet_received_in_order = function()
         print("Packet received in order!")
         local data, err = connskt:receive("*l")
         if data then
            print("Received:", data)
         else
            print("Error:", err)
         end               
      end,

      packet_received_out_of_order = function()
         print("Packet received out of order!")
      end,
      
      connection_closed = function()
         print("Connection closed callback!")
         disp:notify(join)
      end,

      connection_failure = function()
         print("Server: Connection failure callback!")
         disp:notify(join)
      end,
      
   })
   
   print("Waiting...")
   disp:wait(join)
   serverskt:close()
   print("done")
end

local disp = dispatcher.new()
disp:start(main)
