
local timer = {}

require("compat52")
local socket = require("socket")

local function timer_cancel(self)
   self.scheduler:notify(self, "cancel")
   return true
end

local function timer_reset(self)
   if self.idle then
      return true
   end
   self.scheduler:notify(self, "reset")
   return true
end

local function timer_loop_fn(self, coro)
   self.idle = false
   local time = self.delay
   while true do
      assert(self.idle == false)
      local ok, event = self.scheduler:wait(self, time)
      if ok then
         if event == "cancel" then
            break
         elseif event == "reset" then
            time = self.period
         end
      else
         assert(event == "timeout")
         self.fn(self, table.unpack(self.args))
         if not self.idle and self.period > 0 then
            self.idle = false
            self.delay = self.period
            time = self.period
         else
            break
         end
      end
   end
   self.idle = true
end

local function timer_schedule(self, delay, period)
   if not period then period = 0 end
   if not self.idle then
      return nil, "already scheduled"
   end
   self.delay = delay
   self.period = period
   self.canceling = false
   self.timer_loop_coro = coroutine.create(timer_loop_fn)
   self.scheduler:set_thread_name(self.name, self.timer_loop_coro)
   local ok, err = coroutine.resume(self.timer_loop_coro, self, self.timer_loop_coro)
   if not ok then error(err, 2) end
   return true
end

local timer_mt = {
   __gc = function(self)
      self:cancel()
   end
}

function timer.new(scheduler, name, fn, ...)
   assert(type(name) == "string")
   assert(type(fn) == "function")
   local self = {
      scheduler = scheduler,
      name = name,
      fn = fn,
      args = table.pack(...),
      
      idle = true,
      cancel_lock = {},
      canceling = false,
      cancel = timer_cancel,
      reset = timer_reset,
      schedule = timer_schedule,
   }
   setmetatable(self, timer_mt)
   return self
end

return timer
