/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClassLoaderManager;
import component.AbstractComponentWrapper;
import component.IComponent;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ComponentManager {
    protected final ClassLoaderManager classLoaderManager;
    protected final Map<String, List<AbstractComponentWrapper<?, ?, ?>>> wrapperInstanceCollection;
    protected final Map<String, Class<? extends AbstractComponentWrapper<? extends IComponent<?, ?>, ?, ?>>> wrapperMapper;

    public ComponentManager(ClassLoaderManager classLoaderManager, Map<String, Class<? extends AbstractComponentWrapper<? extends IComponent<?, ?>, ?, ?>>> wrapperMapper) {
        this.classLoaderManager = classLoaderManager;
        this.wrapperInstanceCollection = new LinkedHashMap();
        this.wrapperMapper = wrapperMapper;
    }

    public <ComponentType extends IComponent<State, ConstructionParameters>, State, ConstructionParameters> ComponentType createComponentInstance(String componentName) throws Exception {
        return this.createComponentInstance(componentName, null);
    }

    public <ComponentType extends IComponent<State, ConstructionParameters>, State, ConstructionParameters> ComponentType createComponentInstance(String componentName, String componentClass) throws Exception {
        ComponentType componentInstance = componentClass != null ? this.newComponentInstance(componentName, componentClass) : this.newComponentInstance(componentName);
        AbstractComponentWrapper<ComponentType, State, ConstructionParameters> wrapperInstance = this.setComponentInstanceToWrapper(componentName, componentInstance);
        this.addWrapperInstance(componentName, wrapperInstance);
        return (ComponentType)wrapperInstance;
    }

    private <ComponentType extends IComponent<State, ConstructionParameters>, State, ConstructionParameters> AbstractComponentWrapper<ComponentType, State, ConstructionParameters> setComponentInstanceToWrapper(String componentName, ComponentType componentInstance) throws Exception {
        Class<AbstractComponentWrapper<IComponent<?, ?>, ?, ?>> wrapperClass = this.wrapperMapper.get(componentName);
        if (wrapperClass == null) {
            throw new ClassNotFoundException("Wrapper not found for " + componentName);
        }
        AbstractComponentWrapper<IComponent<?, ?>, ?, ?> wrapperInstance = wrapperClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        wrapperInstance.setComponentInstance(componentInstance);
        return wrapperInstance;
    }

    private <ComponentType extends IComponent<State, ConstructionParameters>, State, ConstructionParameters> ComponentType newComponentInstance(String componentName) throws Exception {
        Class<IComponent<?, ?>> componentClass = this.classLoaderManager.getClass(componentName);
        IComponent<?, ?> componentInstance = componentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        return (ComponentType)componentInstance;
    }

    private <ComponentType extends IComponent<State, ConstructionParameters>, State, ConstructionParameters> ComponentType newComponentInstance(String componentName, String componentClassName) throws Exception {
        Class<IComponent<?, ?>> componentClass = this.classLoaderManager.getClass(componentName, componentClassName);
        IComponent<?, ?> componentInstance = componentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        return (ComponentType)componentInstance;
    }

    private void addWrapperInstance(String componentName, AbstractComponentWrapper<?, ?, ?> componentInstance) {
        List<AbstractComponentWrapper<?, ?, ?>> wrapperInstancelist = this.wrapperInstanceCollection.get(componentName);
        if (wrapperInstancelist != null) {
            wrapperInstancelist.add(componentInstance);
        } else {
            wrapperInstancelist = new LinkedList();
            wrapperInstancelist.add(componentInstance);
            this.wrapperInstanceCollection.put(componentName, wrapperInstancelist);
        }
    }

    public void updateComponentInstances(String componentName, boolean transactionalUpdate) throws Exception {
        List<AbstractComponentWrapper<?, ?, ?>> wrapperInstancelist = this.wrapperInstanceCollection.get(componentName);
        if (wrapperInstancelist == null) {
            return;
        }
        for (AbstractComponentWrapper<?, ?, ?> componentWrapper : wrapperInstancelist) {
            Object componentInstance = this.newComponentInstance(componentName);
            componentWrapper.setFutureComponentInstance((IComponent<?, ?>)componentInstance);
            componentWrapper.updateComponentInstance(transactionalUpdate);
        }
    }

    public void commitUpdateComponentInstances(String componentName) {
        List<AbstractComponentWrapper<?, ?, ?>> wrapperInstancelist = this.wrapperInstanceCollection.get(componentName);
        if (wrapperInstancelist != null) {
            for (AbstractComponentWrapper<?, ?, ?> componentWrapper : wrapperInstancelist) {
                componentWrapper.commitUpdateComponentInstance();
            }
        }
    }
}

