/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientManager;
import client.IConnection;
import data.AdaptationResponse;
import data.AdaptationResponseWrapper;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.objects.PrivateMessage;
import lac.cnet.sddl.udi.core.SddlLayer;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import lac.cnet.sddl.udi.core.listener.UDIDataReaderListener;

public class DdsConnection
implements IConnection,
UDIDataReaderListener<ApplicationObject> {
    protected final SddlLayer dds;
    protected ClientManager clientManager;

    public DdsConnection(ClientManager clientManager) {
        this.clientManager = clientManager;
        this.dds = UniversalDDSLayerFactory.getInstance();
        this.dds.createParticipant(0L);
        Object adaptationResponseTopic = this.dds.createTopic(AdaptationResponseWrapper.class, AdaptationResponseWrapper.class.getSimpleName());
        this.dds.createSubscriber();
        this.dds.createPublisher();
        this.dds.createDataWriter(adaptationResponseTopic);
        Object privateMessageTopic = this.dds.createTopic(PrivateMessage.class, PrivateMessage.class.getSimpleName());
        this.dds.createDataReader(this, privateMessageTopic);
    }

    @Override
    public boolean sendMessage(ApplicationMessage message) {
        AdaptationResponseWrapper messageTopic = new AdaptationResponseWrapper();
        messageTopic.setMessage(((AdaptationResponse)message.getContentObject()).message);
        messageTopic.setMessageCode(((AdaptationResponse)message.getContentObject()).messageCode);
        messageTopic.setAdaptationId(((AdaptationResponse)message.getContentObject()).adaptationId);
        return this.dds.writeTopic(AdaptationResponseWrapper.class.getSimpleName(), messageTopic);
    }

    public boolean initialize(Object state) {
        return false;
    }

    public boolean loadState(Object state) {
        return false;
    }

    public Object getState() {
        return null;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public void onNewData(ApplicationObject topicSample) {
        this.clientManager.newMessageReceived(topicSample);
    }
}

