/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.cdr;

import com.rti.dds.cdr.IllegalCdrStateException;
import java.util.Arrays;

public final class CdrBuffer {
    private byte[] _buffer;
    private int _bufferSize;
    private int _desBufferSize = 0;
    private int _position = 0;
    private int _mark = 0;
    private int _savePosition = 0;
    public int _bitBuffer;
    public int _bitBufferLength;

    public CdrBuffer(int n) {
        this(new byte[n], n);
    }

    public CdrBuffer(byte[] byArray, int n) {
        CdrBuffer.checkBufferSize(n, 1);
        this.setBuffer(byArray, n);
        this._bitBufferLength = 0;
        this._bitBuffer = 0;
    }

    public int getSize() {
        return this._bufferSize;
    }

    public void setDesBufferSize(int n) {
        this._desBufferSize = n;
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    public void resize(int n) {
        if (this._bufferSize != n) {
            byte[] byArray = new byte[n];
            this.setBuffer(byArray, n);
            this._bitBufferLength = 0;
            this._bitBuffer = 0;
        }
    }

    public int flushToNative(long l, int n) {
        if (n < this._position) {
            return -1;
        }
        CdrBuffer.flushToNative(l, this._buffer, this._position);
        return this._position;
    }

    public void flushToJava(long l, int n) {
        int n2 = n;
        if (this._bufferSize < n) {
            n2 = this._bufferSize;
        }
        this._desBufferSize = n2;
        CdrBuffer.flushToJava(this._buffer, l, n2);
    }

    public void align(int n) {
        this._position = (this._position - this._savePosition + n - 1 & ~(n - 1)) + this._savePosition;
    }

    public int available() {
        return this._desBufferSize - this._position;
    }

    public int currentPosition() {
        return this._position;
    }

    public void setCurrentPosition(int n) {
        this._position = n;
    }

    public byte get() {
        try {
            return this._buffer[this._position++];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            IllegalCdrStateException illegalCdrStateException = new IllegalCdrStateException("insufficient space in CDR buffer (expected " + (this._desBufferSize - this._position) + " more bytes)");
            throw illegalCdrStateException;
        }
    }

    public int get(byte[] byArray, int n, int n2) {
        int n3 = Math.min(n2, this.available());
        if (n3 > 0) {
            this.getI(byArray, n, n3);
        } else if (n2 != 0) {
            n3 = -1;
        }
        return n3;
    }

    void getI(byte[] byArray, int n, int n2) {
        try {
            System.arraycopy(this._buffer, this._position, byArray, n, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            IllegalCdrStateException illegalCdrStateException = new IllegalCdrStateException("get: not enough available space in cdr buffer. Len=" + n2 + "Available=" + this.available());
            throw illegalCdrStateException;
        }
        this._position += n2;
    }

    public void checkSize(int n) {
        if (this._position + n > this._desBufferSize) {
            throw new IllegalCdrStateException("not enough available space in CDR buffer");
        }
    }

    public long skip(long l) {
        long l2 = Math.min(l, (long)this.available());
        if (l2 > 0L) {
            this._position = (int)((long)this._position + l2);
        } else if (l != 0L) {
            l2 = -1L;
        }
        return l2;
    }

    public void put(byte by) {
        try {
            this._buffer[this._position++] = by;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            IllegalCdrStateException illegalCdrStateException = new IllegalCdrStateException("not enough available space in CDR buffer");
            throw illegalCdrStateException;
        }
    }

    public void put(byte[] byArray, int n, int n2) {
        try {
            System.arraycopy(byArray, n, this._buffer, this._position, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            IllegalCdrStateException illegalCdrStateException = new IllegalCdrStateException("put: not enough available space in CDR buffer");
            throw illegalCdrStateException;
        }
        this._position += n2;
    }

    public void mark() {
        this._mark = this._position;
    }

    public void reset() {
        this._position = this._mark;
    }

    public void resetToZero() {
        this._position = 0;
    }

    public void resetBufferToZero() {
        Arrays.fill(this._buffer, (byte)0);
    }

    public final int resetAlignment() {
        int n = this._savePosition;
        this._savePosition = this._position;
        return n;
    }

    public final int resetAlignmentWithOffset(int n) {
        int n2 = this._savePosition;
        this._savePosition = this._position - n;
        return n2;
    }

    public final void restoreAlignment(int n) {
        this._savePosition = n;
    }

    public void setBits(int n, int n2) {
        if (n2 >= 32) {
            this._bitBuffer = n;
            this._bitBufferLength = n2;
        } else {
            this._bitBuffer += (n & (1 << n2) - 1) << this._bitBufferLength;
            this._bitBufferLength += n2;
        }
    }

    public int getBits(int n) {
        if (n >= 32) {
            this._bitBufferLength = n;
            return this._bitBuffer;
        }
        int n2 = this._bitBuffer >> this._bitBufferLength & (1 << n) - 1;
        this._bitBufferLength += n;
        return n2;
    }

    public void skipBits(int n) {
        this._bitBufferLength = n >= 32 ? n : (this._bitBufferLength += n);
    }

    public void resetBitsBuffer() {
        this._bitBufferLength = 0;
        this._bitBuffer = 0;
    }

    void setBuffer(byte[] byArray, int n) {
        CdrBuffer.checkBufferSize(n, 0);
        if (byArray.length < n) {
            throw new IllegalArgumentException("inconsistent arguments: " + byArray.length + " < " + n);
        }
        this._buffer = byArray;
        this._bufferSize = n;
        this._desBufferSize = n;
    }

    private static void checkBufferSize(int n, int n2) {
        if (n < n2) {
            throw new IllegalArgumentException("buffer size too small: " + n + " < " + n2);
        }
    }

    private static native void flushToNative(long var0, byte[] var2, int var3);

    private static native void flushToJava(byte[] var0, long var1, int var3);
}

