/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.domain;

import com.rti.dds.infrastructure.AbstractNativeObject;
import com.rti.dds.infrastructure.RETCODE_OUT_OF_RESOURCES;
import com.rti.dds.util.Utilities;
import com.rti.ndds.config.ModuleLogger;

public final class NativeRunnable
implements Runnable {
    private final long _function;
    private final long _param;
    private long _nativeCurrentThread = 0L;
    private static final int RUN_STATE_NOT_STARTED = 0;
    private static final int RUN_STATE_RUNNING = 1;
    private static final int RUN_STATE_FINISHED = 2;
    private int _runState = 0;
    private final Object _nativeThreadAccessLock = new Object();
    private static final int TIMEOUT_MILLIS = 30000;
    private static final RuntimeException CANT_GET_THREAD = new RETCODE_OUT_OF_RESOURCES("can't get native thread");

    public NativeRunnable(long l, long l2) {
        AbstractNativeObject.check_for_zeroI(l);
        AbstractNativeObject.check_for_zeroI(l2);
        this._function = l;
        this._param = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.startRunning();
            NativeRunnable.run(this._function, this._param);
        }
        finally {
            this.stopRunning();
        }
    }

    long get_current_native_threadI() {
        long l = System.currentTimeMillis();
        Object object = this._nativeThreadAccessLock;
        synchronized (object) {
            while (this._runState == 0 && System.currentTimeMillis() - l < 30000L) {
                try {
                    this._nativeThreadAccessLock.wait(30000L);
                }
                catch (InterruptedException interruptedException) {
                    ModuleLogger.DDS.logStackTrace(this.getClass(), "get_current_native_threadI", interruptedException);
                }
            }
            switch (this._runState) {
                case 0: {
                    ModuleLogger.DDS.log(1, this.getClass(), "get_current_native_threadI", "!thread started (timed out)");
                    return 0L;
                }
                case 1: {
                    return this._nativeCurrentThread;
                }
                case 2: {
                    ModuleLogger.DDS.log(1, this.getClass(), "get_current_native_threadI", "!thread running (already stopped)");
                    return 0L;
                }
            }
            throw new IllegalArgumentException("undefined run state");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRunning() {
        Object object = this._nativeThreadAccessLock;
        synchronized (object) {
            this._nativeCurrentThread = NativeRunnable.get_native_thread_pointerI();
            if (this._nativeCurrentThread == 0L) {
                Utilities.rethrow(CANT_GET_THREAD);
            }
            this._runState = 1;
            this._nativeThreadAccessLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRunning() {
        Object object = this._nativeThreadAccessLock;
        synchronized (object) {
            this._nativeCurrentThread = 0L;
            this._runState = 2;
            this._nativeThreadAccessLock.notifyAll();
        }
    }

    private static native void run(long var0, long var2);

    private static native long get_native_thread_pointerI();
}

