/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.dynamicdata;

import com.rti.dds.cdr.CdrInputStream;
import com.rti.dds.dynamicdata.DynamicDataInfo;
import com.rti.dds.dynamicdata.DynamicDataMemberInfo;
import com.rti.dds.dynamicdata.DynamicDataProperty_t;
import com.rti.dds.dynamicdata.DynamicDataRetcode;
import com.rti.dds.infrastructure.AbstractNativeObject;
import com.rti.dds.infrastructure.BooleanSeq;
import com.rti.dds.infrastructure.ByteSeq;
import com.rti.dds.infrastructure.CharSeq;
import com.rti.dds.infrastructure.Copyable;
import com.rti.dds.infrastructure.DoubleSeq;
import com.rti.dds.infrastructure.FloatSeq;
import com.rti.dds.infrastructure.IntSeq;
import com.rti.dds.infrastructure.LongSeq;
import com.rti.dds.infrastructure.RETCODE_BAD_PARAMETER;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.RETCODE_OUT_OF_RESOURCES;
import com.rti.dds.infrastructure.ShortSeq;
import com.rti.dds.typecode.TCKind;
import com.rti.dds.typecode.TypeCode;
import com.rti.dds.typecode.TypeCodeFactory;
import com.rti.dds.util.NativeInterface;
import com.rti.dds.util.Utilities;
import java.io.File;

public class DynamicData
implements Copyable {
    private TypeCode _typeCode;
    private long native_dynamic_data;
    private final boolean _created_by_factory;
    private long native_dynamic_data_info;
    private long native_dynamic_data_member_info;
    private static final boolean _swapByteOrder;
    private static final RuntimeException NULL_ARGUMENT;
    private final int[] _actualLength = new int[1];
    private static ThreadLocal _retcode;
    public static final int MEMBER_ID_UNSPECIFIED = 0;
    public static final DynamicDataProperty_t PROPERTY_DEFAULT;

    public void delete() {
        this._typeCode = null;
        if (this.native_dynamic_data != 0L) {
            DynamicData.DDS_DynamicData_delete(this.native_dynamic_data);
            this.native_dynamic_data = 0L;
        }
        if (this.native_dynamic_data_info != 0L) {
            DynamicData.DDS_DynamicData_info_delete(this.native_dynamic_data_info);
            this.native_dynamic_data_info = 0L;
        }
        if (this.native_dynamic_data_member_info != 0L) {
            DynamicData.DDS_DynamicData_member_info_delete(this.native_dynamic_data_member_info);
            this.native_dynamic_data_member_info = 0L;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DynamicData dynamicData = (DynamicData)object;
        if (this == dynamicData) {
            return true;
        }
        return DynamicData.DDS_DynamicData_equal(this.native_dynamic_data, dynamicData.get_native_pointer());
    }

    public int hashCode() {
        return DynamicData.DDS_DynamicData_get_hashcodeI(this.native_dynamic_data);
    }

    public Object copy_from(Object object) {
        DynamicData dynamicData = (DynamicData)object;
        this.copy(dynamicData);
        return this;
    }

    public void copy(DynamicData dynamicData) {
        DynamicData.copy_native(this.native_dynamic_data, dynamicData.get_native_pointer());
    }

    public void clear_all_members() {
        int n = DynamicData.DDS_DynamicData_clear_all_members(this.native_dynamic_data);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void clear_nonkey_members() {
        int n = DynamicData.DDS_DynamicData_clear_nonkey_members(this.native_dynamic_data);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void clear_member(String string, int n) {
        int n2 = DynamicData.DDS_DynamicData_clear_member(this.native_dynamic_data, string, n);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    public void clear_optional_member(String string, int n) {
        int n2 = DynamicData.DDS_DynamicData_clear_optional_member(this.native_dynamic_data, string, n);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    public void compact() {
        int n = DynamicData.DDS_DynamicData_compact(this.native_dynamic_data);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void print(File file, int n) {
        String string = file == null ? null : file.getPath();
        int n2 = DynamicData.DDS_DynamicData_print(this.native_dynamic_data, string, n);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    public int get_serialized_size() {
        return DynamicData.DDS_DynamicData_get_serialized_size(this.native_dynamic_data);
    }

    public void get_info(DynamicDataInfo dynamicDataInfo) {
        this.check_for_null_argumentI(dynamicDataInfo);
        DynamicData.DDS_DynamicData_get_info(this.native_dynamic_data, this.native_dynamic_data_info);
        dynamicDataInfo.pull_from_nativeI(this.native_dynamic_data_info);
    }

    public void bind_type(TypeCode typeCode) {
        this.check_for_null_argumentI(typeCode);
        long l = typeCode.get_native_typecode();
        int n = DynamicData.DDS_DynamicData_bind_type(this.native_dynamic_data, l);
        RETCODE_ERROR.check_return_codeI(n);
        this._typeCode = typeCode;
    }

    public void unbind_type() {
        int n = DynamicData.DDS_DynamicData_unbind_type(this.native_dynamic_data);
        RETCODE_ERROR.check_return_codeI(n);
        this._typeCode = null;
    }

    public void bind_complex_member(DynamicData dynamicData, String string, int n) {
        this.check_for_null_argumentI(dynamicData);
        int n2 = DynamicData.DDS_DynamicData_bind_complex_member(this.native_dynamic_data, dynamicData.get_native_pointer(), string, n);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    public void unbind_complex_member(DynamicData dynamicData) {
        this.check_for_null_argumentI(dynamicData);
        int n = DynamicData.DDS_DynamicData_unbind_complex_member(this.native_dynamic_data, dynamicData.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public TypeCode get_type() {
        return this._typeCode;
    }

    public TCKind get_type_kind() {
        int n = DynamicData.DDS_DynamicData_get_type_kind(this.native_dynamic_data);
        return TCKind.valueOf(n);
    }

    public int get_member_count() {
        return DynamicData.DDS_DynamicData_get_member_count(this.native_dynamic_data);
    }

    public boolean member_exists(String string, int n) {
        return DynamicData.DDS_DynamicData_member_exists(this.native_dynamic_data, string, n);
    }

    public boolean member_exists_in_type(String string, int n) {
        return DynamicData.DDS_DynamicData_member_exists_in_type(this.native_dynamic_data, string, n);
    }

    public void get_member_info(DynamicDataMemberInfo dynamicDataMemberInfo, String string, int n) {
        this.check_for_null_argumentI(dynamicDataMemberInfo);
        int n2 = DynamicData.DDS_DynamicData_get_member_info(this.native_dynamic_data, this.native_dynamic_data_member_info, string, n);
        RETCODE_ERROR.check_return_codeI(n2);
        dynamicDataMemberInfo.pull_from_nativeI(this.native_dynamic_data_member_info);
    }

    public void get_member_info_by_index(DynamicDataMemberInfo dynamicDataMemberInfo, int n) {
        this.check_for_null_argumentI(dynamicDataMemberInfo);
        int n2 = DynamicData.DDS_DynamicData_get_member_info_by_index(this.native_dynamic_data, this.native_dynamic_data_member_info, n);
        RETCODE_ERROR.check_return_codeI(n2);
        dynamicDataMemberInfo.pull_from_nativeI(this.native_dynamic_data_member_info);
    }

    public TypeCode get_member_type(String string, int n) {
        byte[] byArray = DynamicData.DDS_DynamicData_get_member_type(this.native_dynamic_data, string, n);
        CdrInputStream cdrInputStream = null;
        TypeCode typeCode = null;
        if (byArray != null) {
            cdrInputStream = new CdrInputStream(byArray, _swapByteOrder);
            typeCode = TypeCodeFactory.TheTypeCodeFactory.create_tc_from_stream(cdrInputStream);
        }
        return typeCode;
    }

    public boolean is_member_key(String string, int n) {
        return DynamicData.DDS_DynamicData_is_member_key(this.native_dynamic_data, string, n);
    }

    public boolean is_zero_copy_supported() {
        return DynamicData.DDS_DynamicData_is_zero_copy_supported(this.native_dynamic_data);
    }

    public int get_int(String string, int n) {
        DynamicDataRetcode dynamicDataRetcode = (DynamicDataRetcode)_retcode.get();
        int[] nArray = dynamicDataRetcode.returnCode;
        int n2 = DynamicData.DDS_DynamicData_get_long(this.native_dynamic_data, string, n, nArray);
        RETCODE_ERROR.check_return_codeI(nArray[0]);
        return n2;
    }

    public int get_int_array(int[] nArray, String string, int n) {
        int n2 = nArray == null ? 0 : nArray.length;
        int n3 = DynamicData.DDS_DynamicData_get_long_array(this.native_dynamic_data, string, n, nArray, n2, this._actualLength);
        RETCODE_ERROR.check_return_codeI(n3);
        return this._actualLength[0];
    }

    public void get_int_seq(IntSeq intSeq, String string, int n) {
        this.check_for_null_argumentI(intSeq);
        int[] nArray = (int[])intSeq.getPrimitiveArray();
        int n2 = intSeq.size();
        int n3 = intSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_get_long_seq(this.native_dynamic_data, string, n, intSeq, nArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public short get_short(String string, int n) {
        DynamicDataRetcode dynamicDataRetcode = (DynamicDataRetcode)_retcode.get();
        int[] nArray = dynamicDataRetcode.returnCode;
        short s = DynamicData.DDS_DynamicData_get_short(this.native_dynamic_data, string, n, nArray);
        RETCODE_ERROR.check_return_codeI(nArray[0]);
        return s;
    }

    public int get_short_array(short[] sArray, String string, int n) {
        int n2 = sArray == null ? 0 : sArray.length;
        int n3 = DynamicData.DDS_DynamicData_get_short_array(this.native_dynamic_data, string, n, sArray, n2, this._actualLength);
        RETCODE_ERROR.check_return_codeI(n3);
        return this._actualLength[0];
    }

    public void get_short_seq(ShortSeq shortSeq, String string, int n) {
        this.check_for_null_argumentI(shortSeq);
        short[] sArray = (short[])shortSeq.getPrimitiveArray();
        int n2 = shortSeq.size();
        int n3 = shortSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_get_short_seq(this.native_dynamic_data, string, n, shortSeq, sArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public float get_float(String string, int n) {
        DynamicDataRetcode dynamicDataRetcode = (DynamicDataRetcode)_retcode.get();
        int[] nArray = dynamicDataRetcode.returnCode;
        float f = DynamicData.DDS_DynamicData_get_float(this.native_dynamic_data, string, n, nArray);
        RETCODE_ERROR.check_return_codeI(nArray[0]);
        return f;
    }

    public int get_float_array(float[] fArray, String string, int n) {
        int n2 = fArray == null ? 0 : fArray.length;
        int n3 = DynamicData.DDS_DynamicData_get_float_array(this.native_dynamic_data, string, n, fArray, n2, this._actualLength);
        RETCODE_ERROR.check_return_codeI(n3);
        return this._actualLength[0];
    }

    public void get_float_seq(FloatSeq floatSeq, String string, int n) {
        this.check_for_null_argumentI(floatSeq);
        float[] fArray = (float[])floatSeq.getPrimitiveArray();
        int n2 = floatSeq.size();
        int n3 = floatSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_get_float_seq(this.native_dynamic_data, string, n, floatSeq, fArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public double get_double(String string, int n) {
        DynamicDataRetcode dynamicDataRetcode = (DynamicDataRetcode)_retcode.get();
        int[] nArray = dynamicDataRetcode.returnCode;
        double d = DynamicData.DDS_DynamicData_get_double(this.native_dynamic_data, string, n, nArray);
        RETCODE_ERROR.check_return_codeI(nArray[0]);
        return d;
    }

    public int get_double_array(double[] dArray, String string, int n) {
        int n2 = dArray == null ? 0 : dArray.length;
        int n3 = DynamicData.DDS_DynamicData_get_double_array(this.native_dynamic_data, string, n, dArray, n2, this._actualLength);
        RETCODE_ERROR.check_return_codeI(n3);
        return this._actualLength[0];
    }

    public void get_double_seq(DoubleSeq doubleSeq, String string, int n) {
        this.check_for_null_argumentI(doubleSeq);
        double[] dArray = (double[])doubleSeq.getPrimitiveArray();
        int n2 = doubleSeq.size();
        int n3 = doubleSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_get_double_seq(this.native_dynamic_data, string, n, doubleSeq, dArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public boolean get_boolean(String string, int n) {
        DynamicDataRetcode dynamicDataRetcode = (DynamicDataRetcode)_retcode.get();
        int[] nArray = dynamicDataRetcode.returnCode;
        boolean bl = DynamicData.DDS_DynamicData_get_boolean(this.native_dynamic_data, string, n, nArray);
        RETCODE_ERROR.check_return_codeI(nArray[0]);
        return bl;
    }

    public int get_boolean_array(boolean[] blArray, String string, int n) {
        int n2 = blArray == null ? 0 : blArray.length;
        int n3 = DynamicData.DDS_DynamicData_get_boolean_array(this.native_dynamic_data, string, n, blArray, n2, this._actualLength);
        RETCODE_ERROR.check_return_codeI(n3);
        return this._actualLength[0];
    }

    public void get_boolean_seq(BooleanSeq booleanSeq, String string, int n) {
        this.check_for_null_argumentI(booleanSeq);
        boolean[] blArray = (boolean[])booleanSeq.getPrimitiveArray();
        int n2 = booleanSeq.size();
        int n3 = booleanSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_get_boolean_seq(this.native_dynamic_data, string, n, booleanSeq, blArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public char get_char(String string, int n) {
        DynamicDataRetcode dynamicDataRetcode = (DynamicDataRetcode)_retcode.get();
        int[] nArray = dynamicDataRetcode.returnCode;
        char c = DynamicData.DDS_DynamicData_get_char(this.native_dynamic_data, string, n, nArray);
        RETCODE_ERROR.check_return_codeI(nArray[0]);
        return c;
    }

    public int get_char_array(char[] cArray, String string, int n) {
        int n2 = cArray == null ? 0 : cArray.length;
        int n3 = DynamicData.DDS_DynamicData_get_char_array(this.native_dynamic_data, string, n, cArray, n2, this._actualLength);
        RETCODE_ERROR.check_return_codeI(n3);
        return this._actualLength[0];
    }

    public void get_char_seq(CharSeq charSeq, String string, int n) {
        this.check_for_null_argumentI(charSeq);
        char[] cArray = (char[])charSeq.getPrimitiveArray();
        int n2 = charSeq.size();
        int n3 = charSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_get_char_seq(this.native_dynamic_data, string, n, charSeq, cArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public byte get_byte(String string, int n) {
        DynamicDataRetcode dynamicDataRetcode = (DynamicDataRetcode)_retcode.get();
        int[] nArray = dynamicDataRetcode.returnCode;
        byte by = DynamicData.DDS_DynamicData_get_octet(this.native_dynamic_data, string, n, nArray);
        RETCODE_ERROR.check_return_codeI(nArray[0]);
        return by;
    }

    public int get_byte_array(byte[] byArray, String string, int n) {
        int n2 = byArray == null ? 0 : byArray.length;
        int n3 = DynamicData.DDS_DynamicData_get_octet_array(this.native_dynamic_data, string, n, byArray, n2, this._actualLength);
        RETCODE_ERROR.check_return_codeI(n3);
        return this._actualLength[0];
    }

    public void get_byte_seq(ByteSeq byteSeq, String string, int n) {
        this.check_for_null_argumentI(byteSeq);
        byte[] byArray = (byte[])byteSeq.getPrimitiveArray();
        int n2 = byteSeq.size();
        int n3 = byteSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_get_octet_seq(this.native_dynamic_data, string, n, byteSeq, byArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public long get_long(String string, int n) {
        DynamicDataRetcode dynamicDataRetcode = (DynamicDataRetcode)_retcode.get();
        int[] nArray = dynamicDataRetcode.returnCode;
        long l = DynamicData.DDS_DynamicData_get_longlong(this.native_dynamic_data, string, n, nArray);
        RETCODE_ERROR.check_return_codeI(nArray[0]);
        return l;
    }

    public int get_long_array(long[] lArray, String string, int n) {
        int n2 = lArray == null ? 0 : lArray.length;
        int n3 = DynamicData.DDS_DynamicData_get_longlong_array(this.native_dynamic_data, string, n, lArray, n2, this._actualLength);
        RETCODE_ERROR.check_return_codeI(n3);
        return this._actualLength[0];
    }

    public void get_long_seq(LongSeq longSeq, String string, int n) {
        this.check_for_null_argumentI(longSeq);
        long[] lArray = (long[])longSeq.getPrimitiveArray();
        int n2 = longSeq.size();
        int n3 = longSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_get_longlong_seq(this.native_dynamic_data, string, n, longSeq, lArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public String get_string(String string, int n) {
        DynamicDataRetcode dynamicDataRetcode = (DynamicDataRetcode)_retcode.get();
        int[] nArray = dynamicDataRetcode.returnCode;
        String string2 = DynamicData.DDS_DynamicData_get_string(this.native_dynamic_data, string, n, nArray);
        RETCODE_ERROR.check_return_codeI(nArray[0]);
        return string2;
    }

    public void get_complex_member(DynamicData dynamicData, String string, int n) {
        this.check_for_null_argumentI(dynamicData);
        int n2 = DynamicData.DDS_DynamicData_get_complex_member(this.native_dynamic_data, dynamicData.get_native_pointer(), string, n);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    public void set_int(String string, int n, int n2) {
        int n3 = DynamicData.DDS_DynamicData_set_long(this.native_dynamic_data, string, n, n2);
        RETCODE_ERROR.check_return_codeI(n3);
    }

    public void set_int_array(String string, int n, int[] nArray) {
        int n2 = nArray == null ? 0 : nArray.length;
        int n3 = DynamicData.DDS_DynamicData_set_long_array(this.native_dynamic_data, string, n, nArray, n2);
        RETCODE_ERROR.check_return_codeI(n3);
    }

    public void set_int_seq(String string, int n, IntSeq intSeq) {
        this.check_for_null_argumentI(intSeq);
        int[] nArray = (int[])intSeq.getPrimitiveArray();
        int n2 = intSeq.size();
        int n3 = intSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_set_long_seq(this.native_dynamic_data, string, n, nArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public void set_short(String string, int n, short s) {
        int n2 = DynamicData.DDS_DynamicData_set_short(this.native_dynamic_data, string, n, s);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    public void set_short_array(String string, int n, short[] sArray) {
        int n2 = sArray == null ? 0 : sArray.length;
        int n3 = DynamicData.DDS_DynamicData_set_short_array(this.native_dynamic_data, string, n, sArray, n2);
        RETCODE_ERROR.check_return_codeI(n3);
    }

    public void set_short_seq(String string, int n, ShortSeq shortSeq) {
        this.check_for_null_argumentI(shortSeq);
        short[] sArray = (short[])shortSeq.getPrimitiveArray();
        int n2 = shortSeq.size();
        int n3 = shortSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_set_short_seq(this.native_dynamic_data, string, n, sArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public void set_float(String string, int n, float f) {
        int n2 = DynamicData.DDS_DynamicData_set_float(this.native_dynamic_data, string, n, f);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    public void set_float_array(String string, int n, float[] fArray) {
        int n2 = fArray == null ? 0 : fArray.length;
        int n3 = DynamicData.DDS_DynamicData_set_float_array(this.native_dynamic_data, string, n, fArray, n2);
        RETCODE_ERROR.check_return_codeI(n3);
    }

    public void set_float_seq(String string, int n, FloatSeq floatSeq) {
        this.check_for_null_argumentI(floatSeq);
        float[] fArray = (float[])floatSeq.getPrimitiveArray();
        int n2 = floatSeq.size();
        int n3 = floatSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_set_float_seq(this.native_dynamic_data, string, n, fArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public void set_double(String string, int n, double d) {
        int n2 = DynamicData.DDS_DynamicData_set_double(this.native_dynamic_data, string, n, d);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    public void set_double_array(String string, int n, double[] dArray) {
        int n2 = dArray == null ? 0 : dArray.length;
        int n3 = DynamicData.DDS_DynamicData_set_double_array(this.native_dynamic_data, string, n, dArray, n2);
        RETCODE_ERROR.check_return_codeI(n3);
    }

    public void set_double_seq(String string, int n, DoubleSeq doubleSeq) {
        this.check_for_null_argumentI(doubleSeq);
        double[] dArray = (double[])doubleSeq.getPrimitiveArray();
        int n2 = doubleSeq.size();
        int n3 = doubleSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_set_double_seq(this.native_dynamic_data, string, n, dArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public void set_boolean(String string, int n, boolean bl) {
        int n2 = DynamicData.DDS_DynamicData_set_boolean(this.native_dynamic_data, string, n, bl);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    public void set_boolean_array(String string, int n, boolean[] blArray) {
        int n2 = blArray == null ? 0 : blArray.length;
        int n3 = DynamicData.DDS_DynamicData_set_boolean_array(this.native_dynamic_data, string, n, blArray, n2);
        RETCODE_ERROR.check_return_codeI(n3);
    }

    public void set_boolean_seq(String string, int n, BooleanSeq booleanSeq) {
        this.check_for_null_argumentI(booleanSeq);
        boolean[] blArray = (boolean[])booleanSeq.getPrimitiveArray();
        int n2 = booleanSeq.size();
        int n3 = booleanSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_set_boolean_seq(this.native_dynamic_data, string, n, blArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public void set_char(String string, int n, char c) {
        int n2 = DynamicData.DDS_DynamicData_set_char(this.native_dynamic_data, string, n, c);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    public void set_char_array(String string, int n, char[] cArray) {
        int n2 = cArray == null ? 0 : cArray.length;
        int n3 = DynamicData.DDS_DynamicData_set_char_array(this.native_dynamic_data, string, n, cArray, n2);
        RETCODE_ERROR.check_return_codeI(n3);
    }

    public void set_char_seq(String string, int n, CharSeq charSeq) {
        this.check_for_null_argumentI(charSeq);
        char[] cArray = (char[])charSeq.getPrimitiveArray();
        int n2 = charSeq.size();
        int n3 = charSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_set_char_seq(this.native_dynamic_data, string, n, cArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public void set_byte(String string, int n, byte by) {
        int n2 = DynamicData.DDS_DynamicData_set_octet(this.native_dynamic_data, string, n, by);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    public void set_byte_array(String string, int n, byte[] byArray) {
        int n2 = byArray == null ? 0 : byArray.length;
        int n3 = DynamicData.DDS_DynamicData_set_octet_array(this.native_dynamic_data, string, n, byArray, n2);
        RETCODE_ERROR.check_return_codeI(n3);
    }

    public void set_byte_seq(String string, int n, ByteSeq byteSeq) {
        this.check_for_null_argumentI(byteSeq);
        byte[] byArray = (byte[])byteSeq.getPrimitiveArray();
        int n2 = byteSeq.size();
        int n3 = byteSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_set_octet_seq(this.native_dynamic_data, string, n, byArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public void set_long(String string, int n, long l) {
        int n2 = DynamicData.DDS_DynamicData_set_longlong(this.native_dynamic_data, string, n, l);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    public void set_long_array(String string, int n, long[] lArray) {
        int n2 = lArray == null ? 0 : lArray.length;
        int n3 = DynamicData.DDS_DynamicData_set_longlong_array(this.native_dynamic_data, string, n, lArray, n2);
        RETCODE_ERROR.check_return_codeI(n3);
    }

    public void set_long_seq(String string, int n, LongSeq longSeq) {
        this.check_for_null_argumentI(longSeq);
        long[] lArray = (long[])longSeq.getPrimitiveArray();
        int n2 = longSeq.size();
        int n3 = longSeq.getMaximum();
        int n4 = DynamicData.DDS_DynamicData_set_longlong_seq(this.native_dynamic_data, string, n, lArray, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public void set_string(String string, int n, String string2) {
        int n2 = DynamicData.DDS_DynamicData_set_string(this.native_dynamic_data, string, n, string2);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    public void set_complex_member(String string, int n, DynamicData dynamicData) {
        this.check_for_null_argumentI(dynamicData);
        int n2 = DynamicData.DDS_DynamicData_set_complex_member(this.native_dynamic_data, string, n, dynamicData.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n2);
    }

    void pull_from_nativeI(long l) {
        DynamicData.copy_native(this.native_dynamic_data, l);
    }

    void push_to_nativeI(long l) {
        DynamicData.copy_native(l, this.native_dynamic_data);
    }

    protected long get_native_pointer() {
        return this.native_dynamic_data;
    }

    protected void clear_native_pointer() {
        if (!this._created_by_factory) {
            throw new IllegalStateException("can't clear pointer: memory leak");
        }
        this.native_dynamic_data = 0L;
    }

    protected void finalize() throws Throwable {
        this.delete();
        super.finalize();
    }

    public DynamicData() {
        this(null, PROPERTY_DEFAULT);
    }

    public DynamicData(TypeCode typeCode, DynamicDataProperty_t dynamicDataProperty_t) {
        this(DynamicData.create_native_dynamic_data(typeCode, dynamicDataProperty_t), false);
        this._typeCode = typeCode;
    }

    public DynamicData(DynamicData dynamicData) {
        this(dynamicData.get_type(), PROPERTY_DEFAULT);
        try {
            this.copy_from(dynamicData);
        }
        catch (RuntimeException runtimeException) {
            this.delete();
            throw runtimeException;
        }
    }

    DynamicData(long l) {
        this(l, true);
        byte[] byArray = DynamicData.DDS_DynamicData_get_type(l);
        CdrInputStream cdrInputStream = new CdrInputStream(byArray, _swapByteOrder);
        this._typeCode = TypeCodeFactory.TheTypeCodeFactory.create_tc_from_stream(cdrInputStream);
    }

    private DynamicData(long l, boolean bl) {
        if (l == 0L) {
            throw new IllegalStateException("null native dynamic data");
        }
        this.native_dynamic_data = l;
        this._created_by_factory = bl;
        try {
            this.native_dynamic_data_info = DynamicData.DDS_DynamicData_info_new();
            this.native_dynamic_data_member_info = DynamicData.DDS_DynamicData_member_info_new();
            if (this.native_dynamic_data_info == 0L || this.native_dynamic_data_member_info == 0L) {
                throw new RETCODE_OUT_OF_RESOURCES("unable to allocate DynamicDataInfo or DynamicDataMemberInfo");
            }
        }
        catch (RuntimeException runtimeException) {
            this.delete();
            throw runtimeException;
        }
    }

    private static long create_native_dynamic_data(TypeCode typeCode, DynamicDataProperty_t dynamicDataProperty_t) {
        long l = 0L;
        l = typeCode != null ? DynamicData.DDS_DynamicData_new(typeCode.get_native_typecode(), dynamicDataProperty_t.buffer_initial_size, dynamicDataProperty_t.buffer_max_size, dynamicDataProperty_t.buffer_max_size_increment) : DynamicData.DDS_DynamicData_new(0L, dynamicDataProperty_t.buffer_initial_size, dynamicDataProperty_t.buffer_max_size, dynamicDataProperty_t.buffer_max_size_increment);
        if (l == 0L) {
            throw new RETCODE_ERROR();
        }
        return l;
    }

    private static void copy_native(long l, long l2) {
        AbstractNativeObject.check_for_zeroI(l);
        AbstractNativeObject.check_for_zeroI(l2);
        int n = DynamicData.DDS_DynamicData_copy(l, l2);
        RETCODE_ERROR.check_return_codeI(n);
    }

    private final void check_for_null_argumentI(Object object) {
        if (object == null) {
            Utilities.rethrow(NULL_ARGUMENT);
        }
    }

    private static native long DDS_DynamicData_new(long var0, int var2, int var3, int var4);

    private static native long DDS_DynamicData_info_new();

    private static native long DDS_DynamicData_member_info_new();

    private static native void DDS_DynamicData_delete(long var0);

    private static native void DDS_DynamicData_info_delete(long var0);

    private static native void DDS_DynamicData_member_info_delete(long var0);

    private static native boolean DDS_DynamicData_equal(long var0, long var2);

    private static native int DDS_DynamicData_copy(long var0, long var2);

    private static native int DDS_DynamicData_clear_all_members(long var0);

    private static native int DDS_DynamicData_clear_nonkey_members(long var0);

    private static native int DDS_DynamicData_clear_member(long var0, String var2, int var3);

    private static native int DDS_DynamicData_clear_optional_member(long var0, String var2, int var3);

    private static native int DDS_DynamicData_compact(long var0);

    private static native int DDS_DynamicData_print(long var0, String var2, int var3);

    private static native int DDS_DynamicData_get_serialized_size(long var0);

    private static native int DDS_DynamicData_bind_type(long var0, long var2);

    private static native int DDS_DynamicData_unbind_type(long var0);

    private static native int DDS_DynamicData_bind_complex_member(long var0, long var2, String var4, int var5);

    private static native int DDS_DynamicData_unbind_complex_member(long var0, long var2);

    private static native byte[] DDS_DynamicData_get_type(long var0);

    private static native int DDS_DynamicData_get_type_kind(long var0);

    private static native int DDS_DynamicData_get_member_count(long var0);

    private static native boolean DDS_DynamicData_member_exists(long var0, String var2, int var3);

    private static native boolean DDS_DynamicData_member_exists_in_type(long var0, String var2, int var3);

    private static native byte[] DDS_DynamicData_get_member_type(long var0, String var2, int var3);

    private static native boolean DDS_DynamicData_is_member_key(long var0, String var2, int var3);

    private static native boolean DDS_DynamicData_is_zero_copy_supported(long var0);

    private static native int DDS_DynamicData_get_hashcodeI(long var0);

    private static native int DDS_DynamicData_get_long(long var0, String var2, int var3, int[] var4);

    private static native int DDS_DynamicData_get_long_array(long var0, String var2, int var3, int[] var4, int var5, int[] var6);

    private static native int DDS_DynamicData_get_long_seq(long var0, String var2, int var3, Object var4, int[] var5, int var6, int var7);

    private static native short DDS_DynamicData_get_short(long var0, String var2, int var3, int[] var4);

    private static native int DDS_DynamicData_get_short_array(long var0, String var2, int var3, short[] var4, int var5, int[] var6);

    private static native int DDS_DynamicData_get_short_seq(long var0, String var2, int var3, Object var4, short[] var5, int var6, int var7);

    private static native float DDS_DynamicData_get_float(long var0, String var2, int var3, int[] var4);

    private static native int DDS_DynamicData_get_float_array(long var0, String var2, int var3, float[] var4, int var5, int[] var6);

    private static native int DDS_DynamicData_get_float_seq(long var0, String var2, int var3, Object var4, float[] var5, int var6, int var7);

    private static native double DDS_DynamicData_get_double(long var0, String var2, int var3, int[] var4);

    private static native int DDS_DynamicData_get_double_array(long var0, String var2, int var3, double[] var4, int var5, int[] var6);

    private static native int DDS_DynamicData_get_double_seq(long var0, String var2, int var3, Object var4, double[] var5, int var6, int var7);

    private static native boolean DDS_DynamicData_get_boolean(long var0, String var2, int var3, int[] var4);

    private static native int DDS_DynamicData_get_boolean_array(long var0, String var2, int var3, boolean[] var4, int var5, int[] var6);

    private static native int DDS_DynamicData_get_boolean_seq(long var0, String var2, int var3, Object var4, boolean[] var5, int var6, int var7);

    private static native char DDS_DynamicData_get_char(long var0, String var2, int var3, int[] var4);

    private static native int DDS_DynamicData_get_char_array(long var0, String var2, int var3, char[] var4, int var5, int[] var6);

    private static native int DDS_DynamicData_get_char_seq(long var0, String var2, int var3, Object var4, char[] var5, int var6, int var7);

    private static native byte DDS_DynamicData_get_octet(long var0, String var2, int var3, int[] var4);

    private static native int DDS_DynamicData_get_octet_array(long var0, String var2, int var3, byte[] var4, int var5, int[] var6);

    private static native int DDS_DynamicData_get_octet_seq(long var0, String var2, int var3, Object var4, byte[] var5, int var6, int var7);

    private static native long DDS_DynamicData_get_longlong(long var0, String var2, int var3, int[] var4);

    private static native int DDS_DynamicData_get_longlong_array(long var0, String var2, int var3, long[] var4, int var5, int[] var6);

    private static native int DDS_DynamicData_get_longlong_seq(long var0, String var2, int var3, Object var4, long[] var5, int var6, int var7);

    private static native String DDS_DynamicData_get_string(long var0, String var2, int var3, int[] var4);

    private static native int DDS_DynamicData_get_complex_member(long var0, long var2, String var4, int var5);

    private static native int DDS_DynamicData_set_long(long var0, String var2, int var3, int var4);

    private static native int DDS_DynamicData_set_long_array(long var0, String var2, int var3, int[] var4, int var5);

    private static native int DDS_DynamicData_set_long_seq(long var0, String var2, int var3, int[] var4, int var5, int var6);

    private static native int DDS_DynamicData_set_short(long var0, String var2, int var3, short var4);

    private static native int DDS_DynamicData_set_short_array(long var0, String var2, int var3, short[] var4, int var5);

    private static native int DDS_DynamicData_set_short_seq(long var0, String var2, int var3, short[] var4, int var5, int var6);

    private static native int DDS_DynamicData_set_float(long var0, String var2, int var3, float var4);

    private static native int DDS_DynamicData_set_float_array(long var0, String var2, int var3, float[] var4, int var5);

    private static native int DDS_DynamicData_set_float_seq(long var0, String var2, int var3, float[] var4, int var5, int var6);

    private static native int DDS_DynamicData_set_double(long var0, String var2, int var3, double var4);

    private static native int DDS_DynamicData_set_double_array(long var0, String var2, int var3, double[] var4, int var5);

    private static native int DDS_DynamicData_set_double_seq(long var0, String var2, int var3, double[] var4, int var5, int var6);

    private static native int DDS_DynamicData_set_boolean(long var0, String var2, int var3, boolean var4);

    private static native int DDS_DynamicData_set_boolean_array(long var0, String var2, int var3, boolean[] var4, int var5);

    private static native int DDS_DynamicData_set_boolean_seq(long var0, String var2, int var3, boolean[] var4, int var5, int var6);

    private static native int DDS_DynamicData_set_char(long var0, String var2, int var3, char var4);

    private static native int DDS_DynamicData_set_char_array(long var0, String var2, int var3, char[] var4, int var5);

    private static native int DDS_DynamicData_set_char_seq(long var0, String var2, int var3, char[] var4, int var5, int var6);

    private static native int DDS_DynamicData_set_octet(long var0, String var2, int var3, byte var4);

    private static native int DDS_DynamicData_set_octet_array(long var0, String var2, int var3, byte[] var4, int var5);

    private static native int DDS_DynamicData_set_octet_seq(long var0, String var2, int var3, byte[] var4, int var5, int var6);

    private static native int DDS_DynamicData_set_longlong(long var0, String var2, int var3, long var4);

    private static native int DDS_DynamicData_set_longlong_array(long var0, String var2, int var3, long[] var4, int var5);

    private static native int DDS_DynamicData_set_longlong_seq(long var0, String var2, int var3, long[] var4, int var5, int var6);

    private static native int DDS_DynamicData_set_string(long var0, String var2, int var3, String var4);

    private static native int DDS_DynamicData_set_complex_member(long var0, String var2, int var3, long var4);

    private static native void DDS_DynamicData_get_info(long var0, long var2);

    private static native int DDS_DynamicData_get_member_info(long var0, long var2, String var4, int var5);

    private static native int DDS_DynamicData_get_member_info_by_index(long var0, long var2, int var4);

    static {
        NULL_ARGUMENT = new RETCODE_BAD_PARAMETER("null argument");
        _retcode = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new DynamicDataRetcode();
            }
        };
        PROPERTY_DEFAULT = new DynamicDataProperty_t();
        NativeInterface.getInstance().loadNativeLibraries();
        _swapByteOrder = NativeInterface.getInstance().isNativeByteOrderLittleEndian();
    }
}

