/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.dynamicdata;

import com.rti.dds.infrastructure.Struct;

public class DynamicDataInfo
extends Struct {
    public int member_count;
    public int stored_size;
    public boolean is_optimized_storage;

    public DynamicDataInfo() {
        this.member_count = 0;
        this.stored_size = 0;
        this.is_optimized_storage = false;
    }

    public DynamicDataInfo(int n, int n2, boolean bl) {
        this.member_count = n;
        this.stored_size = n2;
        this.is_optimized_storage = bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof DynamicDataInfo) {
            DynamicDataInfo dynamicDataInfo = (DynamicDataInfo)object;
            bl = this.member_count == dynamicDataInfo.member_count && this.stored_size == dynamicDataInfo.stored_size && this.is_optimized_storage == dynamicDataInfo.is_optimized_storage;
        }
        return bl;
    }

    public int hashCode() {
        return this.member_count + this.stored_size + (this.is_optimized_storage ? 1 : 0);
    }

    public void pull_from_nativeI(long l) {
        this.member_count = DynamicDataInfo.get_native_member_countI(l);
        this.stored_size = DynamicDataInfo.get_native_stored_sizeI(l);
        this.is_optimized_storage = DynamicDataInfo.get_native_is_optimized_storageI(l);
    }

    public void push_to_nativeI(long l) {
        throw new UnsupportedOperationException("Can't push DynamicDataInfo to native");
    }

    private static native int get_native_member_countI(long var0);

    private static native int get_native_stored_sizeI(long var0);

    private static native boolean get_native_is_optimized_storageI(long var0);
}

