/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.dynamicdata;

import com.rti.dds.dynamicdata.DynamicData;
import com.rti.dds.dynamicdata.DynamicDataProperty_t;
import com.rti.dds.infrastructure.InstanceHandle_t;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.Time_t;
import com.rti.dds.infrastructure.WriteParams_t;
import com.rti.dds.publication.DataWriter;
import com.rti.dds.publication.DataWriterImpl;
import com.rti.dds.publication.DataWriterListener;
import com.rti.dds.topic.TypeSupportImpl;
import com.rti.dds.typecode.TypeCode;

public final class DynamicDataWriter
extends DataWriterImpl
implements DataWriter {
    public InstanceHandle_t register_instance(DynamicData dynamicData) {
        InstanceHandle_t instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        if (dynamicData == null || !this.is_alive()) {
            return instanceHandle_t;
        }
        long l = DynamicDataWriter.get_scratchpad_instancehandleI(this.get_native_pointer());
        boolean bl = DynamicDataWriter.DDS_DynamicDataWriter_register_instance(this.get_native_pointer(), dynamicData.get_native_pointer(), dynamicData, l);
        if (bl) {
            instanceHandle_t = new InstanceHandle_t(instanceHandle_t);
            instanceHandle_t.pull_from_nativeI(l);
        }
        return instanceHandle_t;
    }

    public InstanceHandle_t register_instance_untyped(Object object) {
        return this.register_instance((DynamicData)object);
    }

    public InstanceHandle_t register_instance_w_timestamp(DynamicData dynamicData, Time_t time_t) {
        InstanceHandle_t instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        if (dynamicData == null || !this.is_alive() || time_t == null || time_t.is_invalid()) {
            return instanceHandle_t;
        }
        long l = DynamicDataWriter.get_scratchpad_instancehandleI(this.get_native_pointer());
        boolean bl = DynamicDataWriter.DDS_DynamicDataWriter_register_instance_w_timestamp(this.get_native_pointer(), dynamicData.get_native_pointer(), dynamicData, l, time_t.sec, time_t.nanosec);
        if (bl) {
            instanceHandle_t = new InstanceHandle_t(instanceHandle_t);
            instanceHandle_t.pull_from_nativeI(l);
        }
        return instanceHandle_t;
    }

    public InstanceHandle_t register_instance_w_params(DynamicData dynamicData, WriteParams_t writeParams_t) {
        InstanceHandle_t instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        if (dynamicData == null || !this.is_alive() || writeParams_t.source_timestamp == null || writeParams_t.source_timestamp.is_invalid()) {
            return instanceHandle_t;
        }
        long l = this.get_native_pointer();
        long l2 = DynamicDataWriter.get_scratchpad_instancehandleI(l);
        long l3 = DynamicDataWriter.get_scratchpad_writeParamsI(this.get_native_pointer());
        writeParams_t.push_to_nativeI(l3);
        boolean bl = DynamicDataWriter.DDS_DynamicDataWriter_register_instance_w_params(l, dynamicData.get_native_pointer(), dynamicData, l2, l3);
        if (bl) {
            instanceHandle_t = new InstanceHandle_t(instanceHandle_t);
            instanceHandle_t.pull_from_nativeI(l2);
        }
        return instanceHandle_t;
    }

    public InstanceHandle_t register_instance_w_params_untyped(Object object, WriteParams_t writeParams_t) {
        return this.register_instance_w_params((DynamicData)object, writeParams_t);
    }

    public void unregister_instance(DynamicData dynamicData, InstanceHandle_t instanceHandle_t) {
        DynamicDataWriter.DDS_DynamicDataWriter_unregister_instance(this.get_native_pointer(), dynamicData.get_native_pointer(), dynamicData, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
    }

    public void unregister_instance_untyped(Object object, InstanceHandle_t instanceHandle_t) {
        this.unregister_instance((DynamicData)object, instanceHandle_t);
    }

    public void unregister_instance_w_timestamp(DynamicData dynamicData, InstanceHandle_t instanceHandle_t, Time_t time_t) {
        DynamicDataWriter.DDS_DynamicDataWriter_unregister_instance_w_timestamp(this.get_native_pointer(), dynamicData.get_native_pointer(), dynamicData, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil(), time_t.sec, time_t.nanosec);
    }

    public void unregister_instance_w_params(DynamicData dynamicData, WriteParams_t writeParams_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(dynamicData);
        this.check_for_null_argumentI(writeParams_t.source_timestamp);
        if (writeParams_t.handle == null) {
            writeParams_t.handle.copy_from(InstanceHandle_t.HANDLE_NIL);
        }
        long l = DynamicDataWriter.get_scratchpad_writeParamsI(this.get_native_pointer());
        writeParams_t.push_to_nativeI(l);
        int n = DynamicDataWriter.DDS_DynamicDataWriter_unregister_instance_w_params(this.get_native_pointer(), dynamicData.get_native_pointer(), dynamicData, l);
        RETCODE_ERROR.check_return_codeI(n);
        if (writeParams_t.replace_auto) {
            writeParams_t.pull_from_nativeI(l);
        }
    }

    public void write(DynamicData dynamicData, InstanceHandle_t instanceHandle_t) {
        DynamicDataWriter.DDS_DynamicDataWriter_write(this.get_native_pointer(), dynamicData.get_native_pointer(), dynamicData, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
    }

    public void write_untyped(Object object, InstanceHandle_t instanceHandle_t) {
        this.write((DynamicData)object, instanceHandle_t);
    }

    public void write_w_timestamp(DynamicData dynamicData, InstanceHandle_t instanceHandle_t, Time_t time_t) {
        DynamicDataWriter.DDS_DynamicDataWriter_write_w_timestamp(this.get_native_pointer(), dynamicData.get_native_pointer(), dynamicData, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil(), time_t.sec, time_t.nanosec);
    }

    public void write_w_timestamp_untyped(DynamicData dynamicData, InstanceHandle_t instanceHandle_t, Time_t time_t) {
        this.write_w_timestamp(dynamicData, instanceHandle_t, time_t);
    }

    public void write_w_params(DynamicData dynamicData, WriteParams_t writeParams_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(dynamicData);
        this.check_for_null_argumentI(writeParams_t.source_timestamp);
        if (writeParams_t.handle == null) {
            writeParams_t.handle.copy_from(InstanceHandle_t.HANDLE_NIL);
        }
        long l = DynamicDataWriter.get_scratchpad_writeParamsI(this.get_native_pointer());
        writeParams_t.push_to_nativeI(l);
        int n = DynamicDataWriter.DDS_DynamicDataWriter_write_w_params(this.get_native_pointer(), dynamicData.get_native_pointer(), dynamicData, l);
        RETCODE_ERROR.check_return_codeI(n);
        if (writeParams_t.replace_auto) {
            writeParams_t.pull_from_nativeI(l);
        }
    }

    public void write_w_params_untyped(Object object, WriteParams_t writeParams_t) {
        this.write_w_params((DynamicData)object, writeParams_t);
    }

    public void dispose(DynamicData dynamicData, InstanceHandle_t instanceHandle_t) {
        DynamicDataWriter.DDS_DynamicDataWriter_dispose(this.get_native_pointer(), dynamicData.get_native_pointer(), dynamicData, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
    }

    public void dispose_untyped(Object object, WriteParams_t writeParams_t) {
        this.dispose_w_params((DynamicData)object, writeParams_t);
    }

    public void dispose_w_timestamp(DynamicData dynamicData, InstanceHandle_t instanceHandle_t, Time_t time_t) {
        DynamicDataWriter.DDS_DynamicDataWriter_dispose_w_timestamp(this.get_native_pointer(), dynamicData.get_native_pointer(), dynamicData, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil(), time_t.sec, time_t.nanosec);
    }

    public void dispose_w_timestamp_untyped(Object object, InstanceHandle_t instanceHandle_t, Time_t time_t) {
        this.dispose_w_timestamp((DynamicData)object, instanceHandle_t, time_t);
    }

    public void dispose_w_params(DynamicData dynamicData, WriteParams_t writeParams_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(dynamicData);
        this.check_for_null_argumentI(writeParams_t.source_timestamp);
        if (writeParams_t.handle == null) {
            writeParams_t.handle.copy_from(InstanceHandle_t.HANDLE_NIL);
        }
        long l = DynamicDataWriter.get_scratchpad_writeParamsI(this.get_native_pointer());
        writeParams_t.push_to_nativeI(l);
        int n = DynamicDataWriter.DDS_DynamicDataWriter_dispose_w_params(this.get_native_pointer(), dynamicData.get_native_pointer(), dynamicData, l);
        RETCODE_ERROR.check_return_codeI(n);
        if (writeParams_t.replace_auto) {
            writeParams_t.pull_from_nativeI(l);
        }
    }

    public void dispose_w_params_untyped(Object object, WriteParams_t writeParams_t) {
        this.dispose_w_params((DynamicData)object, writeParams_t);
    }

    public void get_key_value(DynamicData dynamicData, InstanceHandle_t instanceHandle_t) {
        DynamicDataWriter.DDS_DynamicDataWriter_get_key_value(this.get_native_pointer(), dynamicData.get_native_pointer(), dynamicData, instanceHandle_t.get_valuesI(), instanceHandle_t.get_lengthI(), !instanceHandle_t.is_nil());
    }

    public InstanceHandle_t lookup_instance(DynamicData dynamicData) {
        InstanceHandle_t instanceHandle_t = InstanceHandle_t.HANDLE_NIL;
        if (dynamicData == null || !this.is_alive()) {
            return instanceHandle_t;
        }
        long l = DynamicDataWriter.get_scratchpad_instancehandleI(this.get_native_pointer());
        boolean bl = DynamicDataWriter.DDS_DynamicDataWriter_lookup_instance(this.get_native_pointer(), dynamicData.get_native_pointer(), dynamicData, l);
        if (bl) {
            instanceHandle_t = new InstanceHandle_t(instanceHandle_t);
            instanceHandle_t.pull_from_nativeI(l);
        }
        return instanceHandle_t;
    }

    public DynamicData create_data(DynamicDataProperty_t dynamicDataProperty_t) {
        String string = this.get_topic().get_type_name();
        TypeCode typeCode = this.get_publisher().get_participant().get_typecode(string);
        return new DynamicData(typeCode, dynamicDataProperty_t);
    }

    public void delete_data(DynamicData dynamicData) {
        dynamicData.delete();
    }

    DynamicDataWriter(long l, DataWriterListener dataWriterListener, int n, TypeSupportImpl typeSupportImpl) {
        super(l, dataWriterListener, n, typeSupportImpl);
    }

    private static native boolean DDS_DynamicDataWriter_register_instance(long var0, long var2, Object var4, long var5);

    private static native void DDS_DynamicDataWriter_unregister_instance(long var0, long var2, Object var4, byte[] var5, int var6, boolean var7);

    private static native boolean DDS_DynamicDataWriter_register_instance_w_timestamp(long var0, long var2, Object var4, long var5, int var7, int var8);

    private static native boolean DDS_DynamicDataWriter_register_instance_w_params(long var0, long var2, Object var4, long var5, long var7);

    private static native void DDS_DynamicDataWriter_unregister_instance_w_timestamp(long var0, long var2, Object var4, byte[] var5, int var6, boolean var7, int var8, int var9);

    private static native int DDS_DynamicDataWriter_unregister_instance_w_params(long var0, long var2, Object var4, long var5);

    private static native void DDS_DynamicDataWriter_write(long var0, long var2, Object var4, byte[] var5, int var6, boolean var7);

    private static native void DDS_DynamicDataWriter_write_w_timestamp(long var0, long var2, Object var4, byte[] var5, int var6, boolean var7, int var8, int var9);

    private static native int DDS_DynamicDataWriter_write_w_params(long var0, long var2, Object var4, long var5);

    private static native void DDS_DynamicDataWriter_dispose(long var0, long var2, Object var4, byte[] var5, int var6, boolean var7);

    private static native void DDS_DynamicDataWriter_dispose_w_timestamp(long var0, long var2, Object var4, byte[] var5, int var6, boolean var7, int var8, int var9);

    private static native int DDS_DynamicDataWriter_dispose_w_params(long var0, long var2, Object var4, long var5);

    private static native void DDS_DynamicDataWriter_get_key_value(long var0, long var2, Object var4, byte[] var5, int var6, boolean var7);

    private static native boolean DDS_DynamicDataWriter_lookup_instance(long var0, long var2, Object var4, long var5);

    private static native long get_scratchpad_instancehandleI(long var0);
}

