/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.NativeObject;
import com.rti.dds.infrastructure.RETCODE_ALREADY_DELETED;
import com.rti.dds.infrastructure.RETCODE_BAD_PARAMETER;
import com.rti.dds.infrastructure.RETCODE_OUT_OF_RESOURCES;
import com.rti.dds.util.Utilities;

public abstract class AbstractNativeObject
implements NativeObject {
    private static final RuntimeException NULL_ARGUMENT = new RETCODE_BAD_PARAMETER("null argument");
    private static final RuntimeException ALREADY_DELETED = new RETCODE_ALREADY_DELETED("already deleted");
    protected static final RuntimeException FAILED_ALLOCATION = new RETCODE_OUT_OF_RESOURCES("unable to allocate native object");
    private long _nativePointer;

    public static void check_for_zeroI(long l) {
        if (l == 0L) {
            throw new IllegalStateException("no native object");
        }
    }

    public static final void check_aliveI(NativeObject nativeObject) {
        if (nativeObject == null || !nativeObject.is_alive()) {
            Utilities.rethrow(ALREADY_DELETED);
        }
    }

    public static final boolean is_aliveI(NativeObject nativeObject) {
        return nativeObject.get_native_pointer() != 0L;
    }

    public final long get_native_pointer() {
        return this._nativePointer;
    }

    public void before_delete_native() {
    }

    public void after_delete_native() {
    }

    public void clear_native_pointer() {
        this._nativePointer = 0L;
    }

    public final boolean is_alive() {
        return AbstractNativeObject.is_aliveI(this);
    }

    protected void set_native_pointer(long l) {
        AbstractNativeObject.check_for_zeroI(l);
        this._nativePointer = l;
    }

    protected AbstractNativeObject(long l) {
        this.set_native_pointer(l);
    }

    protected AbstractNativeObject() {
        this._nativePointer = 0L;
    }

    public final void check_aliveI() {
        if (this._nativePointer == 0L) {
            Utilities.rethrow(ALREADY_DELETED);
        }
    }

    protected final void check_for_null_argumentI(Object object) {
        if (object == null) {
            Utilities.rethrow(NULL_ARGUMENT);
        }
    }
}

