/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.util.AbstractPrimitiveSequence;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ByteSeq
extends AbstractPrimitiveSequence {
    private static final long serialVersionUID = 7969055921435164835L;
    private byte[] _array;

    public ByteSeq() {
        this(0);
    }

    public ByteSeq(int n) {
        super(Byte.class, Byte.TYPE, n);
    }

    public ByteSeq(byte[] byArray) {
        this(byArray.length);
        this.addAllByte(byArray);
    }

    public boolean addAllByte(byte[] byArray, int n, int n2) {
        return this.addAllPrimitive(byArray, n, n2);
    }

    public boolean addAllByte(byte[] byArray) {
        int n = byArray.length;
        return this.addAllByte(byArray, 0, n);
    }

    public void addByte(byte by) {
        this.ensureSpaceForAdditionalElements(1);
        this._array[this._size++] = by;
    }

    public void addByte(int n, byte by) {
        this.shiftAndEnlarge(n);
        this._array[n] = by;
    }

    public byte getByte(int n) {
        this.checkIndexUpperBound(n, false);
        return this._array[n];
    }

    public byte setByte(int n, byte by) {
        this.checkIndexUpperBound(n, false);
        byte by2 = this._array[n];
        this._array[n] = by;
        return by2;
    }

    public void setByte(int n, byte[] byArray, int n2, int n3) {
        this.setPrimitive(n, byArray, n2, n3);
    }

    public byte[] toArrayByte(byte[] byArray) {
        int n = byArray == null ? 0 : byArray.length;
        return (byte[])this.toArrayPrimitive(byArray, n);
    }

    public static void readByteArray(byte[] byArray, ObjectInput objectInput, int n) throws IOException {
        int n2 = objectInput.read(byArray, 0, n);
        if (n2 < n) {
            throw new IOException("unable to read all expected data");
        }
    }

    public static void writeByteArray(byte[] byArray, ObjectOutput objectOutput, int n) throws IOException {
        objectOutput.write(byArray, 0, n);
    }

    public int getMaximum() {
        return this._array == null ? 0 : this._array.length;
    }

    public Object get(int n) {
        byte by = this.getByte(n);
        return new Byte(by);
    }

    public Object getPrimitiveArray() {
        return this._array;
    }

    public void setPrimitiveArray(Object object, int n) {
        this._array = (byte[])object;
        this._size = n;
    }

    public Object set(int n, Object object) {
        byte by = this.setByte(n, (Byte)object);
        return new Byte(by);
    }

    public void add(int n, Object object) {
        this.addByte(n, (Byte)object);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this._size; ++i) {
            n += this._array[i];
        }
        return n;
    }

    protected Object createArray(int n) {
        return new byte[n];
    }

    protected void setPrimitiveArray(Object object) {
        this._array = (byte[])object;
    }

    protected void readElements(ObjectInput objectInput, int n) throws IOException {
        ByteSeq.readByteArray(this._array, objectInput, n);
    }

    protected void writeElements(ObjectOutput objectOutput, int n) throws IOException {
        if (this._array != null) {
            ByteSeq.writeByteArray(this._array, objectOutput, n);
        }
    }
}

