/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.util.AbstractPrimitiveSequence;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CharSeq
extends AbstractPrimitiveSequence {
    private static final long serialVersionUID = -8028479495411628688L;
    protected char[] _array;

    public CharSeq() {
        this(0);
    }

    public CharSeq(int n) {
        super(Character.class, Character.TYPE, n);
    }

    public CharSeq(char[] cArray) {
        this(cArray.length);
        this.addAllChar(cArray);
    }

    public final boolean addAllChar(char[] cArray, int n, int n2) {
        return this.addAllPrimitive(cArray, n, n2);
    }

    public final boolean addAllChar(char[] cArray) {
        int n = cArray.length;
        return this.addAllChar(cArray, 0, n);
    }

    public final void addChar(char c) {
        this.ensureSpaceForAdditionalElements(1);
        this._array[this._size++] = c;
    }

    public final void addChar(int n, char c) {
        this.shiftAndEnlarge(n);
        this._array[n] = c;
    }

    public final char getChar(int n) {
        this.checkIndexUpperBound(n, false);
        return this._array[n];
    }

    public final char setChar(int n, char c) {
        this.checkIndexUpperBound(n, false);
        char c2 = this._array[n];
        this._array[n] = c;
        return c2;
    }

    public final void setChar(int n, char[] cArray, int n2, int n3) {
        this.setPrimitive(n, cArray, n2, n3);
    }

    public final char[] toArrayChar(char[] cArray) {
        int n = cArray == null ? 0 : cArray.length;
        return (char[])this.toArrayPrimitive(cArray, n);
    }

    public static void readCharArray(char[] cArray, DataInput dataInput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)dataInput.readByte();
        }
    }

    public static void writeCharArray(char[] cArray, DataOutput dataOutput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            dataOutput.writeByte(cArray[i]);
        }
    }

    public final int getMaximum() {
        return this._array == null ? 0 : this._array.length;
    }

    public final Object get(int n) {
        char c = this.getChar(n);
        return new Character(c);
    }

    public final Object getPrimitiveArray() {
        return this._array;
    }

    public final void setPrimitiveArray(Object object, int n) {
        this._array = (char[])object;
        this._size = n;
    }

    public final Object set(int n, Object object) {
        char c = this.setChar(n, ((Character)object).charValue());
        return new Character(c);
    }

    public final void add(int n, Object object) {
        this.addChar(n, ((Character)object).charValue());
    }

    public final int hashCode() {
        int n = 0;
        for (int i = 0; i < this._size; ++i) {
            n += this._array[i];
        }
        return n;
    }

    protected final Object createArray(int n) {
        return new char[n];
    }

    protected final void setPrimitiveArray(Object object) {
        this._array = (char[])object;
    }

    protected void readElements(ObjectInput objectInput, int n) throws IOException {
        CharSeq.readCharArray(this._array, objectInput, n);
    }

    protected void writeElements(ObjectOutput objectOutput, int n) throws IOException {
        if (this._array != null) {
            CharSeq.writeCharArray(this._array, objectOutput, n);
        }
    }
}

