/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.GUID_t;
import com.rti.dds.infrastructure.QosPolicy;
import com.rti.dds.infrastructure.QosPolicyId_t;
import com.rti.dds.infrastructure.RtpsReliableWriterProtocol_t;
import com.rti.dds.infrastructure.SequenceNumber_t;

public final class DataWriterProtocolQosPolicy
extends QosPolicy {
    public GUID_t virtual_guid = new GUID_t(GUID_t.GUID_AUTO);
    public int rtps_object_id = 0;
    public boolean push_on_write = true;
    public boolean disable_positive_acks = false;
    public boolean disable_inline_keyhash = false;
    public boolean serialize_key_with_dispose = false;
    public final RtpsReliableWriterProtocol_t rtps_reliable_writer = new RtpsReliableWriterProtocol_t();
    public SequenceNumber_t initial_virtual_sequence_number = new SequenceNumber_t();

    public void copy_from(DataWriterProtocolQosPolicy dataWriterProtocolQosPolicy) {
        this.rtps_object_id = dataWriterProtocolQosPolicy.rtps_object_id;
        this.push_on_write = dataWriterProtocolQosPolicy.push_on_write;
        this.disable_positive_acks = dataWriterProtocolQosPolicy.disable_positive_acks;
        this.disable_inline_keyhash = dataWriterProtocolQosPolicy.disable_inline_keyhash;
        this.serialize_key_with_dispose = dataWriterProtocolQosPolicy.serialize_key_with_dispose;
        this.rtps_reliable_writer.copy_from(dataWriterProtocolQosPolicy.rtps_reliable_writer);
        this.virtual_guid.copy_from(dataWriterProtocolQosPolicy.virtual_guid);
        this.initial_virtual_sequence_number.copy_from(dataWriterProtocolQosPolicy.initial_virtual_sequence_number);
    }

    public void pull_from_nativeI(long l) {
        this.rtps_object_id = DataWriterProtocolQosPolicy.get_native_rtps_object_idI(l);
        int n = DataWriterProtocolQosPolicy.get_native_push_on_writeI(l);
        this.push_on_write = n != 0;
        this.disable_positive_acks = DataWriterProtocolQosPolicy.get_native_disable_positive_acksI(l);
        this.disable_inline_keyhash = DataWriterProtocolQosPolicy.get_native_disable_inline_keyhashI(l);
        this.serialize_key_with_dispose = DataWriterProtocolQosPolicy.get_native_serialize_key_with_disposeI(l);
        long l2 = DataWriterProtocolQosPolicy.get_native_rtps_reliable_writerI(l);
        long l3 = DataWriterProtocolQosPolicy.get_native_virtual_guidI(l);
        this.rtps_reliable_writer.pull_from_nativeI(l2);
        this.virtual_guid.pull_from_nativeI(l3);
        long l4 = DataWriterProtocolQosPolicy.get_native_initial_virtual_sequence_numberI(l);
        this.initial_virtual_sequence_number.pull_from_nativeI(l4);
    }

    public void push_to_nativeI(long l) {
        long l2 = DataWriterProtocolQosPolicy.get_native_rtps_reliable_writerI(l);
        long l3 = DataWriterProtocolQosPolicy.get_native_virtual_guidI(l);
        long l4 = DataWriterProtocolQosPolicy.get_native_initial_virtual_sequence_numberI(l);
        this.rtps_reliable_writer.push_to_nativeI(l2);
        DataWriterProtocolQosPolicy.set_native_push_on_writeI(l, this.push_on_write);
        DataWriterProtocolQosPolicy.set_native_rtps_object_idI(l, this.rtps_object_id);
        DataWriterProtocolQosPolicy.set_native_disable_positive_acksI(l, this.disable_positive_acks);
        DataWriterProtocolQosPolicy.set_native_disable_inline_keyhashI(l, this.disable_inline_keyhash);
        DataWriterProtocolQosPolicy.set_native_serialize_key_with_disposeI(l, this.serialize_key_with_dispose);
        this.virtual_guid.push_to_nativeI(l3);
        this.initial_virtual_sequence_number.push_to_nativeI(l4);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof DataWriterProtocolQosPolicy) {
            DataWriterProtocolQosPolicy dataWriterProtocolQosPolicy = (DataWriterProtocolQosPolicy)object;
            bl = this.rtps_reliable_writer.equals(dataWriterProtocolQosPolicy.rtps_reliable_writer) && this.push_on_write == dataWriterProtocolQosPolicy.push_on_write && this.rtps_object_id == dataWriterProtocolQosPolicy.rtps_object_id && this.disable_positive_acks == dataWriterProtocolQosPolicy.disable_positive_acks && this.disable_inline_keyhash == dataWriterProtocolQosPolicy.disable_inline_keyhash && this.serialize_key_with_dispose == dataWriterProtocolQosPolicy.serialize_key_with_dispose && this.virtual_guid.equals(dataWriterProtocolQosPolicy.virtual_guid) && this.initial_virtual_sequence_number.equals(dataWriterProtocolQosPolicy.initial_virtual_sequence_number);
        }
        return bl;
    }

    public int hashCode() {
        return this.virtual_guid.hashCode() + this.rtps_reliable_writer.hashCode() + (this.push_on_write ? 1 : 0) + (this.disable_positive_acks ? 1 : 0) + (this.disable_inline_keyhash ? 1 : 0) + (this.serialize_key_with_dispose ? 1 : 0) + this.rtps_object_id + this.initial_virtual_sequence_number.hashCode();
    }

    DataWriterProtocolQosPolicy() {
        super(QosPolicyId_t.DATAWRITERPROTOCOL_QOS_POLICY_ID);
    }

    private static native long get_native_rtps_reliable_writerI(long var0);

    private static native int get_native_push_on_writeI(long var0);

    private static native int get_native_rtps_object_idI(long var0);

    private static native boolean get_native_disable_positive_acksI(long var0);

    private static native boolean get_native_serialize_key_with_disposeI(long var0);

    private static native boolean get_native_disable_inline_keyhashI(long var0);

    private static native long get_native_initial_virtual_sequence_numberI(long var0);

    private static native void set_native_push_on_writeI(long var0, boolean var2);

    private static native void set_native_rtps_object_idI(long var0, int var2);

    private static native void set_native_disable_positive_acksI(long var0, boolean var2);

    private static native void set_native_serialize_key_with_disposeI(long var0, boolean var2);

    private static native void set_native_disable_inline_keyhashI(long var0, boolean var2);

    private static native long get_native_virtual_guidI(long var0);
}

