/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.Duration_t;
import com.rti.dds.infrastructure.QosPolicy;
import com.rti.dds.infrastructure.QosPolicyId_t;
import com.rti.dds.infrastructure.ThreadSettings_t;

public final class DatabaseQosPolicy
extends QosPolicy {
    public final ThreadSettings_t thread = new ThreadSettings_t();
    public final Duration_t shutdown_timeout = new Duration_t(3, 0);
    public final Duration_t cleanup_period = new Duration_t(3, 0);
    public final Duration_t shutdown_cleanup_period = new Duration_t(1, 0);
    public int initial_records = 512;
    public int max_skiplist_level = 8;
    public int table_allocation_block_size = 40;
    public int initial_weak_references = 1;
    public int max_weak_references = 512;

    public void pull_from_nativeI(long l) {
        long l2 = DatabaseQosPolicy.get_native_threadI(l);
        this.thread.pull_from_nativeI(l2);
        long l3 = DatabaseQosPolicy.get_native_shutdown_timeoutI(l);
        this.shutdown_timeout.pull_from_nativeI(l3);
        l3 = DatabaseQosPolicy.get_native_cleanup_periodI(l);
        this.cleanup_period.pull_from_nativeI(l3);
        l3 = DatabaseQosPolicy.get_native_shutdown_cleanup_periodI(l);
        this.shutdown_cleanup_period.pull_from_nativeI(l3);
        this.initial_records = DatabaseQosPolicy.get_native_initial_recordsI(l);
        this.max_skiplist_level = DatabaseQosPolicy.get_native_max_skiplist_levelI(l);
        this.table_allocation_block_size = DatabaseQosPolicy.get_native_table_allocation_block_sizeI(l);
        this.initial_weak_references = DatabaseQosPolicy.get_native_initial_weak_referencesI(l);
        this.max_weak_references = DatabaseQosPolicy.get_native_max_weak_referencesI(l);
    }

    public void push_to_nativeI(long l) {
        long l2 = DatabaseQosPolicy.get_native_threadI(l);
        this.thread.push_to_nativeI(l2);
        long l3 = DatabaseQosPolicy.get_native_shutdown_timeoutI(l);
        this.shutdown_timeout.push_to_nativeI(l3);
        l3 = DatabaseQosPolicy.get_native_cleanup_periodI(l);
        this.cleanup_period.push_to_nativeI(l3);
        l3 = DatabaseQosPolicy.get_native_shutdown_cleanup_periodI(l);
        this.shutdown_cleanup_period.push_to_nativeI(l3);
        DatabaseQosPolicy.push_to_nativeI(l, this.initial_records, this.max_skiplist_level, this.table_allocation_block_size, this.initial_weak_references, this.max_weak_references);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof DatabaseQosPolicy) {
            DatabaseQosPolicy databaseQosPolicy = (DatabaseQosPolicy)object;
            bl = this.thread.equals(databaseQosPolicy.thread) && this.shutdown_timeout.equals(databaseQosPolicy.shutdown_timeout) && this.cleanup_period.equals(databaseQosPolicy.cleanup_period) && this.shutdown_cleanup_period.equals(databaseQosPolicy.shutdown_cleanup_period) && this.initial_records == databaseQosPolicy.initial_records && this.max_skiplist_level == databaseQosPolicy.max_skiplist_level && this.table_allocation_block_size == databaseQosPolicy.table_allocation_block_size && this.initial_weak_references == databaseQosPolicy.initial_weak_references && this.max_weak_references == databaseQosPolicy.max_weak_references;
        }
        return bl;
    }

    public int hashCode() {
        return this.thread.hashCode() + this.shutdown_timeout.hashCode() + this.cleanup_period.hashCode() + this.shutdown_cleanup_period.hashCode() + this.initial_records + this.max_skiplist_level + this.table_allocation_block_size + this.initial_weak_references + this.max_weak_references;
    }

    protected void check_consistentI() {
        super.check_consistentI();
        this.thread.check_consistentI();
    }

    DatabaseQosPolicy() {
        super(QosPolicyId_t.DATABASE_QOS_POLICY_ID);
    }

    private static native long get_native_threadI(long var0);

    private static native long get_native_shutdown_timeoutI(long var0);

    private static native long get_native_cleanup_periodI(long var0);

    private static native long get_native_shutdown_cleanup_periodI(long var0);

    private static native int get_native_initial_recordsI(long var0);

    private static native int get_native_max_skiplist_levelI(long var0);

    private static native int get_native_table_allocation_block_sizeI(long var0);

    private static native int get_native_initial_weak_referencesI(long var0);

    private static native int get_native_max_weak_referencesI(long var0);

    private static native void push_to_nativeI(long var0, int var2, int var3, int var4, int var5, int var6);
}

