/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.QosPolicy;
import com.rti.dds.infrastructure.QosPolicyId_t;
import com.rti.dds.infrastructure.StringSeq;

public final class DiscoveryQosPolicy
extends QosPolicy {
    public final StringSeq enabled_transports = new StringSeq();
    public final StringSeq multicast_receive_addresses = new StringSeq();
    public int metatraffic_transport_priority;
    public final StringSeq initial_peers = new StringSeq();
    public boolean accept_unknown_peers = true;

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof DiscoveryQosPolicy) {
            DiscoveryQosPolicy discoveryQosPolicy = (DiscoveryQosPolicy)object;
            bl = this.enabled_transports.equals(discoveryQosPolicy.enabled_transports) && this.multicast_receive_addresses.equals(discoveryQosPolicy.multicast_receive_addresses) && this.metatraffic_transport_priority == discoveryQosPolicy.metatraffic_transport_priority && this.initial_peers.equals(discoveryQosPolicy.initial_peers) && this.accept_unknown_peers == discoveryQosPolicy.accept_unknown_peers;
        }
        return bl;
    }

    public int hashCode() {
        return this.enabled_transports.hashCode() + this.enabled_transports.size() + this.multicast_receive_addresses.hashCode() + this.multicast_receive_addresses.size() + this.metatraffic_transport_priority + this.initial_peers.hashCode() + this.initial_peers.size() + (this.accept_unknown_peers ? 1 : 0);
    }

    public void pull_from_nativeI(long l) {
        this.enabled_transports.pull_from_nativeI(DiscoveryQosPolicy.get_native_enabled_transportsI(l));
        this.multicast_receive_addresses.pull_from_nativeI(DiscoveryQosPolicy.get_native_multicast_receive_addressesI(l));
        this.metatraffic_transport_priority = DiscoveryQosPolicy.get_native_metatraffic_transport_priorityI(l);
        this.initial_peers.pull_from_nativeI(DiscoveryQosPolicy.get_native_initial_peersI(l));
        this.accept_unknown_peers = DiscoveryQosPolicy.get_native_accept_unknown_peersI(l) != 0;
    }

    public void push_to_nativeI(long l) {
        this.enabled_transports.push_to_nativeI(DiscoveryQosPolicy.get_native_enabled_transportsI(l));
        this.multicast_receive_addresses.push_to_nativeI(DiscoveryQosPolicy.get_native_multicast_receive_addressesI(l));
        DiscoveryQosPolicy.set_native_metatraffic_transport_priorityI(l, this.metatraffic_transport_priority);
        this.initial_peers.push_to_nativeI(DiscoveryQosPolicy.get_native_initial_peersI(l));
        DiscoveryQosPolicy.set_native_accept_unknown_peersI(l, this.accept_unknown_peers);
    }

    DiscoveryQosPolicy() {
        super(QosPolicyId_t.DISCOVERY_QOS_POLICY_ID);
    }

    private static native long get_native_enabled_transportsI(long var0);

    private static native long get_native_multicast_receive_addressesI(long var0);

    private static native int get_native_metatraffic_transport_priorityI(long var0);

    private static native void set_native_metatraffic_transport_priorityI(long var0, int var2);

    private static native long get_native_initial_peersI(long var0);

    private static native int get_native_accept_unknown_peersI(long var0);

    private static native void set_native_accept_unknown_peersI(long var0, boolean var2);
}

