/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.Struct;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class Duration_t
extends Struct
implements Externalizable {
    public static final int DURATION_ZERO_SEC = 0;
    public static final int DURATION_ZERO_NSEC = 0;
    public static final int DURATION_INFINITE_SEC = Integer.MAX_VALUE;
    public static final int DURATION_INFINITY_SEC = Integer.MAX_VALUE;
    public static final int DURATION_INFINITE_NSEC = Integer.MAX_VALUE;
    public static final int DURATION_INFINITY_NSEC = Integer.MAX_VALUE;
    public static final int DURATION_AUTO_SEC = -1;
    public static final int DURATION_AUTO_NSEC = 0;
    public static final Duration_t DURATION_ZERO = new Duration_t();
    public static final Duration_t DURATION_INFINITE = new Duration_t(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final Duration_t DURATION_AUTO = new Duration_t(-1, 0);
    public int sec;
    public int nanosec;

    public Duration_t() {
        this(0, 0);
    }

    public Duration_t(Duration_t duration_t) {
        this(duration_t.sec, duration_t.nanosec);
    }

    public Duration_t(int n, int n2) {
        this.sec = n;
        this.nanosec = n2;
    }

    public static Duration_t from_micros(long l) {
        return new Duration_t((int)(l / 1000000L), (int)(l % 1000000L) * 1000);
    }

    public static Duration_t from_nanos(long l) {
        return new Duration_t((int)(l / 1000000000L), (int)(l % 1000000000L));
    }

    public static Duration_t from_millis(long l) {
        return new Duration_t((int)(l / 1000L), (int)(l % 1000L) * 1000000);
    }

    public static Duration_t from_seconds(long l) {
        return new Duration_t((int)l, 0);
    }

    public void copy_from(Duration_t duration_t) {
        this.sec = duration_t.sec;
        this.nanosec = duration_t.nanosec;
    }

    public boolean is_zero() {
        return this.sec == 0 && this.nanosec == 0;
    }

    public boolean is_infinite() {
        return this.sec == Integer.MAX_VALUE || this.nanosec == Integer.MAX_VALUE;
    }

    public boolean is_auto() {
        return this.sec == -1 && this.nanosec == 0;
    }

    public Duration_t add(Duration_t duration_t) {
        if (this.is_infinite() || duration_t.is_infinite()) {
            return new Duration_t(this);
        }
        Duration_t duration_t2 = new Duration_t(this.sec + duration_t.sec, this.nanosec + duration_t.nanosec);
        if (duration_t2.nanosec >= 1000000000) {
            ++duration_t2.sec;
            duration_t2.nanosec -= 1000000000;
        }
        return duration_t2;
    }

    public Duration_t subtract(Duration_t duration_t) {
        if (this.is_infinite() || duration_t.is_infinite()) {
            if (this.is_infinite()) {
                return new Duration_t(this);
            }
            return new Duration_t(DURATION_ZERO);
        }
        Duration_t duration_t2 = new Duration_t(this.sec - duration_t.sec, this.nanosec - duration_t.nanosec);
        if (duration_t2.nanosec < 0) {
            --duration_t2.sec;
            duration_t2.nanosec += 1000000000;
        }
        if (duration_t2.sec < 0) {
            duration_t2.sec = 0;
            duration_t2.nanosec = 0;
        }
        return duration_t2;
    }

    public void push_to_nativeI(long l) {
        Duration_t.push_to_nativeI(l, this.sec, this.nanosec);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.sec);
        objectOutput.writeInt(this.nanosec);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.sec = objectInput.readInt();
        this.nanosec = objectInput.readInt();
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object.getClass() == this.getClass()) {
            Duration_t duration_t = (Duration_t)object;
            bl = duration_t.sec == this.sec && duration_t.nanosec == this.nanosec;
        }
        return bl;
    }

    public final int hashCode() {
        return this.sec + this.nanosec;
    }

    public void pull_from_nativeI(long l) {
        this.sec = Duration_t.get_native_secI(l);
        this.nanosec = Duration_t.get_native_nanosecI(l);
    }

    private static native void push_to_nativeI(long var0, int var2, int var3);

    private static native int get_native_secI(long var0);

    private static native int get_native_nanosecI(long var0);
}

