/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.QosPolicy;
import com.rti.dds.infrastructure.QosPolicyId_t;
import com.rti.dds.infrastructure.ThreadSettings_t;

public final class EventQosPolicy
extends QosPolicy {
    public final ThreadSettings_t thread = new ThreadSettings_t();
    public int initial_count = 16;
    public int max_count = 64;

    public void pull_from_nativeI(long l) {
        this.initial_count = EventQosPolicy.get_native_initial_countI(l);
        this.max_count = EventQosPolicy.get_native_max_countI(l);
        long l2 = EventQosPolicy.get_native_threadI(l);
        this.thread.pull_from_nativeI(l2);
    }

    public void push_to_nativeI(long l) {
        long l2 = EventQosPolicy.get_native_threadI(l);
        this.thread.push_to_nativeI(l2);
        EventQosPolicy.push_to_nativeI(l, this.initial_count, this.max_count);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof EventQosPolicy) {
            EventQosPolicy eventQosPolicy = (EventQosPolicy)object;
            bl = this.thread.equals(eventQosPolicy.thread) && this.initial_count == this.initial_count && this.max_count == this.max_count;
        }
        return bl;
    }

    public int hashCode() {
        return this.thread.hashCode() + this.initial_count + this.max_count;
    }

    protected void check_consistentI() {
        super.check_consistentI();
        this.thread.check_consistentI();
    }

    EventQosPolicy() {
        super(QosPolicyId_t.EVENT_QOS_POLICY_ID);
    }

    private static native long get_native_threadI(long var0);

    private static native int get_native_initial_countI(long var0);

    private static native int get_native_max_countI(long var0);

    private static native void push_to_nativeI(long var0, int var2, int var3);
}

