/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.util.Ipv6UnsupportedException;
import java.net.InetAddress;
import java.net.UnknownHostException;

final class InetAddressHelper {
    private static final int IPV4_BYTE_COUNT = 4;
    private static final int IPV6_BYTE_COUNT = 16;
    private static final int STRINGIFIED_IPV6_MAX_LEN = 39;
    private static final int STRINGIFIED_IPV4_MAX_LEN = 15;
    private static final InetAddressHelper _singleton = new InetAddressHelper();

    public static InetAddressHelper get_instanceI() {
        return _singleton;
    }

    public InetAddress create_from_nativeI(long l) throws Ipv6UnsupportedException {
        byte[] byArray = InetAddressHelper.get_native_addressI(l);
        boolean bl = false;
        int n = 12;
        for (int i = 0; i < n && !bl; ++i) {
            if (byArray[i] == 0) continue;
            bl = true;
        }
        String string = bl ? this.stringify_ipv6_address(byArray) : this.stringify_ipv4_address(byArray);
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            String string2 = System.getProperty("java.specification.version");
            if (bl && string2.indexOf("1.3") >= 0) {
                throw new Ipv6UnsupportedException(string);
            }
            throw new IllegalStateException("Unknown host: " + string);
        }
        return inetAddress;
    }

    public void push_to_nativeI(long l, InetAddress inetAddress) {
        byte[] byArray;
        byte[] byArray2 = byArray = inetAddress == null ? new byte[16] : inetAddress.getAddress();
        if (byArray.length != 16) {
            byte[] byArray3 = new byte[16];
            int n = 12;
            for (int i = 0; i < n; ++i) {
                byArray3[i] = 0;
            }
            System.arraycopy(byArray, 0, byArray3, n, byArray.length);
            byArray = byArray3;
        }
        InetAddressHelper.set_native_addressI(l, byArray);
    }

    private InetAddressHelper() {
    }

    private String stringify_ipv4_address(byte[] byArray) {
        int n = 12;
        StringBuffer stringBuffer = new StringBuffer(15);
        stringBuffer.append(byArray[n + 0] & 0xFF).append('.');
        stringBuffer.append(byArray[n + 1] & 0xFF).append('.');
        stringBuffer.append(byArray[n + 2] & 0xFF).append('.');
        stringBuffer.append(byArray[n + 3] & 0xFF);
        return stringBuffer.toString();
    }

    private String stringify_ipv6_address(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(39);
        for (int i = 0; i < 39; i += 2) {
            int n = byArray[i] << 8 & 0xFF00 | byArray[i + 1] & 0xFF;
            String string = Integer.toHexString(n);
            stringBuffer.append(string);
            if (i >= 37) continue;
            stringBuffer.append(':');
        }
        return stringBuffer.toString();
    }

    private static native byte[] get_native_addressI(long var0);

    private static native void set_native_addressI(long var0, byte[] var2);
}

