/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.StringHelper;
import com.rti.dds.util.ArraySequence;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;

public final class InetAddressSeq
extends ArraySequence {
    public InetAddressSeq() {
        super(InetAddress.class);
    }

    public InetAddressSeq(int n) {
        super(InetAddress.class, n);
    }

    public InetAddressSeq(Collection collection) {
        super(InetAddress.class, collection);
    }

    void pull_from_nativeI(long l) {
        int n;
        int n2;
        int n3 = InetAddressSeq.get_native_lengthI(l);
        if (n3 < (n2 = this.size())) {
            this.removeRange(n3, n2);
        } else if (n3 > n2) {
            this.ensureCapacity(n3);
            for (n = n2; n < n3; ++n) {
                this.add((Object)null);
            }
        }
        for (n = 0; n < n3; ++n) {
            String string = StringHelper.dup_native_stringI(InetAddressSeq.get_native_element_ptrI(l, n));
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalStateException("Unknown host: " + string);
            }
            this.set(n, inetAddress);
        }
    }

    void push_to_nativeI(long l) {
        int n = this.size();
        int n2 = InetAddressSeq.set_native_lengthI(l, n);
        RETCODE_ERROR.check_return_codeI(n2);
        int n3 = InetAddressSeq.get_native_lengthI(l);
        for (int i = 0; i < n && i < n3; ++i) {
            InetAddress inetAddress = (InetAddress)this.get(i);
            n2 = StringHelper.replace_native_stringI(InetAddressSeq.get_native_element_ptrI(l, i), inetAddress.getHostAddress());
            RETCODE_ERROR.check_return_codeI(n2);
        }
    }

    private static native int get_native_lengthI(long var0);

    private static native int set_native_lengthI(long var0, int var2);

    private static native long get_native_element_ptrI(long var0, int var2);
}

