/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.Duration_t;
import com.rti.dds.infrastructure.LivelinessQosPolicyKind;
import com.rti.dds.infrastructure.QosPolicy;
import com.rti.dds.infrastructure.QosPolicyId_t;
import com.rti.dds.util.Utilities;

public final class LivelinessQosPolicy
extends QosPolicy {
    public LivelinessQosPolicyKind kind = LivelinessQosPolicyKind.AUTOMATIC_LIVELINESS_QOS;
    public final Duration_t lease_duration = new Duration_t(Integer.MAX_VALUE, Integer.MAX_VALUE);

    public void copy_from(LivelinessQosPolicy livelinessQosPolicy) {
        this.kind = livelinessQosPolicy.kind;
        this.lease_duration.copy_from(livelinessQosPolicy.lease_duration);
    }

    public void pull_from_nativeI(long l) {
        LivelinessQosPolicyKind livelinessQosPolicyKind;
        int n = LivelinessQosPolicy.get_native_kindI(l);
        this.kind = livelinessQosPolicyKind = LivelinessQosPolicyKind.valueOf(n);
        long l2 = LivelinessQosPolicy.get_native_lease_duration(l);
        this.lease_duration.pull_from_nativeI(l2);
    }

    public void push_to_nativeI(long l) {
        LivelinessQosPolicy.set_native_kindI(l, this.kind.ordinal());
        long l2 = LivelinessQosPolicy.get_native_lease_duration(l);
        this.lease_duration.push_to_nativeI(l2);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof LivelinessQosPolicy) {
            LivelinessQosPolicy livelinessQosPolicy = (LivelinessQosPolicy)object;
            bl = this.kind == livelinessQosPolicy.kind && this.lease_duration.equals(livelinessQosPolicy.lease_duration);
        }
        return bl;
    }

    public int hashCode() {
        return this.lease_duration.hashCode() + Utilities.hashCodeNullSafe(this.kind);
    }

    LivelinessQosPolicy() {
        super(QosPolicyId_t.LIVELINESS_QOS_POLICY_ID);
    }

    private static native int get_native_kindI(long var0);

    private static native void set_native_kindI(long var0, int var2);

    private static native long get_native_lease_duration(long var0);
}

