/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.cdr.CdrObjectInput;
import com.rti.dds.cdr.CdrObjectOutput;
import com.rti.dds.infrastructure.DoubleSeq;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class LongDoubleSeq
extends DoubleSeq {
    private static final long serialVersionUID = -5195402184499251302L;

    public LongDoubleSeq() {
    }

    public LongDoubleSeq(int n) {
        super(n);
    }

    public LongDoubleSeq(double[] dArray) {
        super(dArray);
    }

    public static void readLongDoubleArray(double[] dArray, DataInput dataInput, int n) throws IOException {
        if (dataInput instanceof CdrObjectInput) {
            CdrObjectInput cdrObjectInput = (CdrObjectInput)dataInput;
            for (int i = 0; i < n; ++i) {
                dArray[i] = cdrObjectInput.readLongDouble();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                dArray[i] = dataInput.readDouble();
            }
        }
    }

    public static void writeLongDoubleArray(double[] dArray, DataOutput dataOutput, int n) throws IOException {
        if (dataOutput instanceof CdrObjectOutput) {
            CdrObjectOutput cdrObjectOutput = (CdrObjectOutput)dataOutput;
            for (int i = 0; i < n; ++i) {
                cdrObjectOutput.writeLongDouble(dArray[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                dataOutput.writeDouble(dArray[i]);
            }
        }
    }

    protected void readElements(ObjectInput objectInput, int n) throws IOException {
        LongDoubleSeq.readLongDoubleArray(this._array, objectInput, n);
    }

    protected void writeElements(ObjectOutput objectOutput, int n) throws IOException {
        if (this._array != null) {
            LongDoubleSeq.writeLongDoubleArray(this._array, objectOutput, n);
        }
    }
}

