/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.AbstractNativeObject;
import com.rti.dds.infrastructure.EntityImpl;
import com.rti.dds.infrastructure.Listener;
import com.rti.dds.infrastructure.RETCODE_BAD_PARAMETER;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.util.Utilities;

public abstract class NativeListenerMixin {
    private static final RuntimeException NO_NATIVE_LISTENER = new RETCODE_ERROR("failed to initialize native listener");
    private static final RuntimeException NO_JAVA_LISTENER = new RETCODE_BAD_PARAMETER("null listener with non-empty mask");
    private long _nativeObject;
    private long _nativeEntity;
    private long _nativeListener;
    private Listener _javaListener;

    public final Listener get_untyped_listenerI() {
        return this._javaListener;
    }

    public void cleanup() {
        long l = this._nativeObject;
        this._nativeObject = 0L;
        this._nativeEntity = 0L;
        this._nativeListener = 0L;
        this._javaListener = null;
        this.destroy_native_listenerI(l);
    }

    protected NativeListenerMixin(Listener listener, int n, long l, long l2) {
        this._nativeObject = l;
        this._nativeEntity = l2;
        AbstractNativeObject.check_for_zeroI(l2);
        AbstractNativeObject.check_for_zeroI(l);
        this._nativeListener = this.initialize_native_listenerI(l);
        if (this._nativeListener == 0L) {
            this.destroy_native_listenerI(l);
            Utilities.rethrow(NO_NATIVE_LISTENER);
        }
        this.set_untyped_listenerI(listener, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void set_untyped_listenerI(Listener listener, int n) {
        AbstractNativeObject.check_for_zeroI(this._nativeObject);
        AbstractNativeObject.check_for_zeroI(this._nativeEntity);
        EntityImpl.lock_native_entityI(this._nativeEntity);
        try {
            if (listener != null) {
                int n2 = this.set_native_listenerI(this._nativeObject, this._nativeListener, n);
                RETCODE_ERROR.check_return_codeI(n2);
            } else {
                int n3 = this.set_native_listenerI(this._nativeObject, 0L, n);
                RETCODE_ERROR.check_return_codeI(n3);
            }
            this._javaListener = listener;
        }
        finally {
            EntityImpl.unlock_native_entityI(this._nativeEntity);
        }
    }

    protected final void destroy() {
        if (this._nativeListener != 0L) {
            this.set_untyped_listenerI(null, 0);
            this._nativeListener = 0L;
            this.destroy_native_listenerI(this._nativeObject);
            this._nativeObject = 0L;
            this._nativeEntity = 0L;
        }
    }

    protected abstract int set_native_listenerI(long var1, long var3, int var5);

    protected abstract long initialize_native_listenerI(long var1);

    protected abstract void destroy_native_listenerI(long var1);
}

