/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.util.AbstractPrimitiveSequence;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ShortSeq
extends AbstractPrimitiveSequence {
    private static final long serialVersionUID = 1199799835817653239L;
    private short[] _array;

    public ShortSeq() {
        this(0);
    }

    public ShortSeq(int n) {
        super(Short.class, Short.TYPE, n);
    }

    public ShortSeq(short[] sArray) {
        this(sArray.length);
        this.addAllShort(sArray);
    }

    public boolean addAllShort(short[] sArray, int n, int n2) {
        return this.addAllPrimitive(sArray, n, n2);
    }

    public boolean addAllShort(short[] sArray) {
        int n = sArray.length;
        return this.addAllShort(sArray, 0, n);
    }

    public void addShort(short s) {
        this.ensureSpaceForAdditionalElements(1);
        this._array[this._size++] = s;
    }

    public void addShort(int n, short s) {
        this.shiftAndEnlarge(n);
        this._array[n] = s;
    }

    public short getShort(int n) {
        this.checkIndexUpperBound(n, false);
        return this._array[n];
    }

    public short setShort(int n, short s) {
        this.checkIndexUpperBound(n, false);
        short s2 = this._array[n];
        this._array[n] = s;
        return s2;
    }

    public void setShort(int n, short[] sArray, int n2, int n3) {
        this.setPrimitive(n, sArray, n2, n3);
    }

    public short[] toArrayShort(short[] sArray) {
        int n = sArray == null ? 0 : sArray.length;
        return (short[])this.toArrayPrimitive(sArray, n);
    }

    public static void readShortArray(short[] sArray, DataInput dataInput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            sArray[i] = dataInput.readShort();
        }
    }

    public static void writeShortArray(short[] sArray, DataOutput dataOutput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            dataOutput.writeShort(sArray[i]);
        }
    }

    public int getMaximum() {
        return this._array == null ? 0 : this._array.length;
    }

    public Object get(int n) {
        short s = this.getShort(n);
        return new Short(s);
    }

    public Object getPrimitiveArray() {
        return this._array;
    }

    public void setPrimitiveArray(Object object, int n) {
        this._array = (short[])object;
        this._size = n;
    }

    public Object set(int n, Object object) {
        short s = this.setShort(n, (Short)object);
        return new Short(s);
    }

    public void add(int n, Object object) {
        this.addShort(n, (Short)object);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this._size; ++i) {
            n += this._array[i];
        }
        return n;
    }

    protected Object createArray(int n) {
        return new short[n];
    }

    protected void setPrimitiveArray(Object object) {
        this._array = (short[])object;
    }

    protected void readElements(ObjectInput objectInput, int n) throws IOException {
        ShortSeq.readShortArray(this._array, objectInput, n);
    }

    protected void writeElements(ObjectOutput objectOutput, int n) throws IOException {
        if (this._array != null) {
            ShortSeq.writeShortArray(this._array, objectOutput, n);
        }
    }
}

