/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.cdr.CdrObjectInput;
import com.rti.dds.cdr.CdrObjectOutput;
import com.rti.dds.infrastructure.Copyable;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.util.ArraySequence;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class StringSeq
extends ArraySequence
implements Copyable,
Externalizable {
    private static final long serialVersionUID = 4383933938484577158L;

    public StringSeq() {
        super(String.class);
    }

    public StringSeq(int n) {
        super(String.class, n);
    }

    public StringSeq(Collection collection) {
        super(String.class, collection);
    }

    public final Object copy_from(Object object) {
        int n;
        StringSeq stringSeq = (StringSeq)object;
        int n2 = stringSeq.size();
        int n3 = this.size();
        this.ensureCapacity(n2);
        if (n2 < n3) {
            this.removeRange(n2, n3);
        }
        for (n = 0; n < n3 && n < n2; ++n) {
            this.set(n, stringSeq.get(n));
        }
        for (n = n3; n < n2; ++n) {
            this.add(stringSeq.get(n));
        }
        return this;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.clear();
        int n = objectInput.readInt();
        if (objectInput instanceof CdrObjectInput) {
            CdrObjectInput cdrObjectInput = (CdrObjectInput)objectInput;
            for (int i = 0; i < n; ++i) {
                this.add(cdrObjectInput.readString());
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.add(objectInput.readUTF());
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.size();
        objectOutput.writeInt(n);
        if (objectOutput instanceof CdrObjectOutput) {
            CdrObjectOutput cdrObjectOutput = (CdrObjectOutput)objectOutput;
            for (int i = 0; i < n; ++i) {
                cdrObjectOutput.writeString((String)this.get(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                objectOutput.writeUTF((String)this.get(i));
            }
        }
    }

    public static void readStringArray(String[] stringArray, CdrObjectInput cdrObjectInput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            stringArray[i] = cdrObjectInput.readString();
        }
    }

    public static void writeStringArray(String[] stringArray, CdrObjectOutput cdrObjectOutput, int n, int n2) throws IOException {
        for (int i = 0; i < n; ++i) {
            cdrObjectOutput.writeString(stringArray[i], n2);
        }
    }

    public final void pull_from_nativeI(long l) {
        int n;
        int n2;
        int n3 = StringSeq.get_native_lengthI(l);
        if (n3 < (n2 = this.size())) {
            this.removeRange(n3, n2);
        } else if (n3 > n2) {
            this.ensureCapacity(n3);
            for (n = n2; n < n3; ++n) {
                this.add((Object)null);
            }
        }
        for (n = 0; n < n3; ++n) {
            String string = StringSeq.get_native_elementI(l, n, (String)this.get(n));
            this.set(n, string);
        }
    }

    public final void push_to_nativeI(long l) {
        int n = this.size();
        int n2 = StringSeq.set_native_lengthI(l, n);
        int n3 = StringSeq.get_native_lengthI(l);
        for (int i = 0; i < n && i < n3; ++i) {
            String string = (String)this.get(i);
            RETCODE_ERROR.check_return_codeI(StringSeq.set_native_elementI(l, i, string));
        }
        RETCODE_ERROR.check_return_codeI(n2);
    }

    private static native int get_native_lengthI(long var0);

    private static native int set_native_lengthI(long var0, int var2);

    private static native String get_native_elementI(long var0, int var2, String var3);

    private static native int set_native_elementI(long var0, int var2, String var3);
}

