/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.IntSeq;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.RETCODE_INCONSISTENT_POLICY;
import com.rti.dds.infrastructure.Struct;
import com.rti.dds.infrastructure.ThreadSettingsCpuRotationKind;
import com.rti.dds.util.Utilities;

public final class ThreadSettings_t
extends Struct {
    public int mask = 0;
    public int priority = 100;
    public int stack_size = 16384;
    public final IntSeq cpu_list = new IntSeq();
    public ThreadSettingsCpuRotationKind cpu_rotation = ThreadSettingsCpuRotationKind.THREAD_SETTINGS_CPU_NO_ROTATION;
    private static final RETCODE_INCONSISTENT_POLICY INCONSISTENT_PRIORITY = new RETCODE_INCONSISTENT_POLICY("priority must be between 1 and 10");

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof ThreadSettings_t) {
            ThreadSettings_t threadSettings_t = (ThreadSettings_t)object;
            bl = this.mask == threadSettings_t.mask && this.priority == threadSettings_t.priority && this.stack_size == threadSettings_t.stack_size && this.cpu_list.equals(threadSettings_t.cpu_list) && this.cpu_rotation == threadSettings_t.cpu_rotation;
        }
        return bl;
    }

    public int hashCode() {
        return this.mask + this.priority + this.stack_size + this.cpu_list.hashCode() + Utilities.hashCodeNullSafe(this.cpu_rotation);
    }

    protected void pull_from_nativeI(long l) {
        ThreadSettingsCpuRotationKind threadSettingsCpuRotationKind;
        this.mask = ThreadSettings_t.get_native_maskI(l);
        this.priority = ThreadSettings_t.get_native_priorityI(l, 1, 5, 10);
        this.stack_size = ThreadSettings_t.get_native_stack_sizeI(l);
        int n = this.pull_ints_from_nativeI(l);
        RETCODE_ERROR.check_return_codeI(n);
        int n2 = ThreadSettings_t.get_native_cpu_rotationI(l);
        this.cpu_rotation = threadSettingsCpuRotationKind = ThreadSettingsCpuRotationKind.valueOf(n2);
    }

    protected void push_to_nativeI(long l) {
        if (this.cpu_rotation == null) {
            RETCODE_ERROR.check_return_codeI(4);
        }
        int n = this.push_ints_to_nativeI(l);
        RETCODE_ERROR.check_return_codeI(n);
        ThreadSettings_t.push_to_nativeI(l, this.mask, this.priority, this.stack_size, this.cpu_rotation.ordinal(), 1, 5, 10);
    }

    ThreadSettings_t() {
    }

    protected void check_consistentI() {
        if (this.priority < 1 || this.priority > 10) {
            Utilities.rethrow(INCONSISTENT_PRIORITY);
        }
    }

    private static native int get_native_maskI(long var0);

    private static native int get_native_priorityI(long var0, int var2, int var3, int var4);

    private static native int get_native_stack_sizeI(long var0);

    private static native int get_native_cpu_rotationI(long var0);

    private native int pull_ints_from_nativeI(long var1);

    private static native void push_to_nativeI(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    private native int push_ints_to_nativeI(long var1);
}

