/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.Copyable;
import com.rti.dds.infrastructure.Struct;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class Time_t
extends Struct
implements Externalizable,
Copyable {
    public static final int TIME_INVALID_SEC = -1;
    public static final int TIMESTAMP_INVALID_SEC = -1;
    public static final int TIME_INVALID_NSEC = -1;
    public static final int TIMESTAMP_INVALID_NSEC = -1;
    public static final Time_t TIME_INVALID = new Time_t(-1, -1);
    public static final Time_t TIME_ZERO = new Time_t(0, 0);
    public int sec;
    public int nanosec;

    public Time_t(Time_t time_t) {
        this(time_t.sec, time_t.nanosec);
    }

    public Time_t(int n, int n2) {
        this.sec = n;
        this.nanosec = n2;
    }

    public static Time_t from_micros(long l) {
        return new Time_t((int)(l / 1000000L), (int)(l % 1000000L) * 1000);
    }

    public static Time_t from_nanos(long l) {
        return new Time_t((int)(l / 1000000000L), (int)(l % 1000000000L));
    }

    public static Time_t from_millis(long l) {
        return new Time_t((int)(l / 1000L), (int)(l % 1000L) * 1000000);
    }

    public static Time_t from_seconds(long l) {
        return new Time_t((int)l, 0);
    }

    public static Time_t now() {
        long l = System.currentTimeMillis();
        return new Time_t((int)(l / 1000L), (int)(l % 1000L * 1000000L));
    }

    public boolean is_invalid() {
        return this.sec < 0 || this.nanosec < 0;
    }

    public boolean is_zero() {
        return this.sec == 0 && this.nanosec == 0;
    }

    public void pull_from_nativeI(long l) {
        this.sec = Time_t.get_native_secI(l);
        this.nanosec = Time_t.get_native_nanosecI(l);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.sec);
        objectOutput.writeInt(this.nanosec);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.sec = objectInput.readInt();
        this.nanosec = objectInput.readInt();
    }

    public Object copy_from(Object object) {
        this.sec = ((Time_t)object).sec;
        this.nanosec = ((Time_t)object).nanosec;
        return this;
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object.getClass() == this.getClass()) {
            Time_t time_t = (Time_t)object;
            bl = time_t.sec == this.sec && time_t.nanosec == this.nanosec;
        }
        return bl;
    }

    public final int hashCode() {
        return this.sec + this.nanosec;
    }

    public void push_to_nativeI(long l) {
        Time_t.push_to_nativeI(l, this.sec, this.nanosec);
    }

    private static native int get_native_secI(long var0);

    private static native int get_native_nanosecI(long var0);

    private static native void push_to_nativeI(long var0, int var2, int var3);
}

