/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.infrastructure;

import com.rti.dds.infrastructure.AbstractNativeObject;
import com.rti.dds.infrastructure.Condition;
import com.rti.dds.infrastructure.ConditionSeq;
import com.rti.dds.infrastructure.Duration_t;
import com.rti.dds.infrastructure.NativeObject;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.WaitSetProperty_t;
import com.rti.dds.util.NativeInterface;
import com.rti.dds.util.Utilities;

public final class WaitSet
extends AbstractNativeObject {
    public WaitSet() {
        long l = this.DDS_WaitSet_new();
        if (l == 0L) {
            Utilities.rethrow(FAILED_ALLOCATION);
        }
        this.set_native_pointer(l);
    }

    public WaitSet(WaitSetProperty_t waitSetProperty_t) {
        this.check_for_null_argumentI(waitSetProperty_t);
        long l = this.get_scratchpad_waitset_propertyI();
        waitSetProperty_t.push_to_nativeI(l);
        long l2 = this.DDS_WaitSet_new_ex(l);
        this.return_scratchpad_waitset_propertyI(l);
        if (l2 == 0L) {
            Utilities.rethrow(FAILED_ALLOCATION);
        }
        this.set_native_pointer(l2);
    }

    public void wait(ConditionSeq conditionSeq, Duration_t duration_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(conditionSeq);
        this.check_for_null_argumentI(duration_t);
        long l = conditionSeq.getNativeSequence();
        int n = this.DDS_WaitSet_wait(this.get_native_pointer(), l, duration_t.sec, duration_t.nanosec);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void attach_condition(Condition condition) {
        this.check_aliveI();
        this.check_for_null_argumentI(condition);
        AbstractNativeObject.check_aliveI((NativeObject)((Object)condition));
        long l = ((NativeObject)((Object)condition)).get_native_pointer();
        int n = this.DDS_WaitSet_attach_condition(this.get_native_pointer(), l);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void detach_condition(Condition condition) {
        this.check_aliveI();
        this.check_for_null_argumentI(condition);
        AbstractNativeObject.check_aliveI((NativeObject)((Object)condition));
        long l = ((NativeObject)((Object)condition)).get_native_pointer();
        int n = this.DDS_WaitSet_detach_condition(this.get_native_pointer(), l);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void get_conditions(ConditionSeq conditionSeq) {
        this.check_aliveI();
        this.check_for_null_argumentI(conditionSeq);
        long l = conditionSeq.getNativeSequence();
        int n = this.DDS_WaitSet_get_conditions(this.get_native_pointer(), l);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void set_property(WaitSetProperty_t waitSetProperty_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(waitSetProperty_t);
        long l = this.get_scratchpad_waitset_propertyI();
        waitSetProperty_t.push_to_nativeI(l);
        int n = this.DDS_WaitSet_set_property(this.get_native_pointer(), l);
        this.return_scratchpad_waitset_propertyI(l);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void get_property(WaitSetProperty_t waitSetProperty_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(waitSetProperty_t);
        long l = this.get_scratchpad_waitset_propertyI();
        int n = this.DDS_WaitSet_get_property(this.get_native_pointer(), l);
        waitSetProperty_t.pull_from_nativeI(l);
        this.return_scratchpad_waitset_propertyI(l);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void delete() {
        long l = this.get_native_pointer();
        if (l == 0L) {
            return;
        }
        this.before_delete_native();
        int n = this.DDS_WaitSet_delete(l);
        RETCODE_ERROR.check_return_codeI(n);
        this.after_delete_native();
    }

    public void after_delete_native() {
        this.clear_native_pointer();
    }

    protected void finalize() throws Throwable {
        this.delete();
        super.finalize();
    }

    private native long DDS_WaitSet_new();

    private native long DDS_WaitSet_new_ex(long var1);

    private native long get_scratchpad_waitset_propertyI();

    private native void return_scratchpad_waitset_propertyI(long var1);

    private native int DDS_WaitSet_wait(long var1, long var3, int var5, int var6);

    private native int DDS_WaitSet_attach_condition(long var1, long var3);

    private native int DDS_WaitSet_detach_condition(long var1, long var3);

    private native int DDS_WaitSet_get_conditions(long var1, long var3);

    private native int DDS_WaitSet_delete(long var1);

    private native int DDS_WaitSet_set_property(long var1, long var3);

    private native int DDS_WaitSet_get_property(long var1, long var3);

    static {
        NativeInterface.getInstance().loadNativeLibraries();
    }
}

