/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.publication;

import com.rti.dds.domain.DomainParticipant;
import com.rti.dds.domain.DomainParticipantFactory;
import com.rti.dds.domain.DomainParticipantImpl;
import com.rti.dds.infrastructure.AbstractNativeObject;
import com.rti.dds.infrastructure.Duration_t;
import com.rti.dds.infrastructure.Entity;
import com.rti.dds.infrastructure.EntityImpl;
import com.rti.dds.infrastructure.Listener;
import com.rti.dds.infrastructure.NativeFactoryMixin;
import com.rti.dds.infrastructure.NativeObject;
import com.rti.dds.infrastructure.NativeStructMixin;
import com.rti.dds.infrastructure.RETCODE_BAD_PARAMETER;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.RETCODE_IMMUTABLE_POLICY;
import com.rti.dds.publication.DataWriter;
import com.rti.dds.publication.DataWriterImpl;
import com.rti.dds.publication.DataWriterListener;
import com.rti.dds.publication.DataWriterQos;
import com.rti.dds.publication.DataWriterSeq;
import com.rti.dds.publication.Publisher;
import com.rti.dds.publication.PublisherListener;
import com.rti.dds.publication.PublisherListenerImpl;
import com.rti.dds.publication.PublisherQos;
import com.rti.dds.topic.KeyHash_t;
import com.rti.dds.topic.NativeTopicDescription;
import com.rti.dds.topic.Topic;
import com.rti.dds.topic.TopicImpl;
import com.rti.dds.topic.TopicQos;
import com.rti.dds.util.Utilities;
import com.rti.ndds.config.ModuleLogger;

public class PublisherImpl
extends EntityImpl
implements Publisher {
    private final NativeFactoryMixin _dataWriterFactory = new DataWriterFactoryMixin();
    private int _cachedAsynchronousPublisherThreadPriority;
    private int _cachedAsynchronousPublisherBatchThreadPriority;
    private static final RuntimeException IMMUTABLE_QOS = new RETCODE_IMMUTABLE_POLICY("immutable qos policy");
    private static final RuntimeException NULL_PROFILE = new RETCODE_BAD_PARAMETER("null profile");
    private static final RuntimeException NULL_LIBRARY = new RETCODE_BAD_PARAMETER("null library");
    private final Object[] _serializeOption = new Object[1];

    public PublisherImpl(long l, PublisherListener publisherListener, int n) {
        super(l, new PublisherListenerImpl(publisherListener, n, l));
        this.initializeQosMixin(new PublisherQosMixin());
    }

    public void cache_qos(PublisherQos publisherQos) {
        this._cachedAsynchronousPublisherThreadPriority = publisherQos.asynchronous_publisher.thread.priority;
        this._cachedAsynchronousPublisherBatchThreadPriority = publisherQos.asynchronous_publisher.asynchronous_batch_thread.priority;
    }

    public void get_default_datawriter_qos(DataWriterQos dataWriterQos) {
        this._dataWriterFactory.get_untypedI(dataWriterQos, null);
    }

    public void get_default_datawriter_qos_w_topic_name(DataWriterQos dataWriterQos, String string) {
        this._dataWriterFactory.get_untypedI(dataWriterQos, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_default_datawriter_qos(DataWriterQos dataWriterQos) {
        boolean bl = dataWriterQos == DATAWRITER_QOS_DEFAULT;
        this.lock();
        try {
            this._serializeOption[0] = bl ? null : dataWriterQos.type_support.plugin_data;
            this._dataWriterFactory.set_untypedI(dataWriterQos, bl, false, this._serializeOption);
        }
        finally {
            this.unlock();
        }
    }

    public void set_default_datawriter_qos_with_profile(String string, String string2) {
        DataWriterQos dataWriterQos = new DataWriterQos();
        this.check_aliveI();
        if (string2 == null) {
            string2 = this.get_default_profile();
            string = this.get_default_profile_library();
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
            return;
        }
        if (string == null && (string = this.get_default_library()) == null) {
            Utilities.rethrow(NULL_LIBRARY);
            return;
        }
        this._dataWriterFactory.set_untypedI(dataWriterQos, false, true, new Object[]{string, string2});
        dataWriterQos = null;
    }

    public DataWriter create_datawriter(Topic topic, DataWriterQos dataWriterQos, DataWriterListener dataWriterListener, int n) {
        DataWriter dataWriter = null;
        if (topic == null) {
            return null;
        }
        if (dataWriterQos == null) {
            return null;
        }
        boolean bl = dataWriterQos == Publisher.DATAWRITER_QOS_DEFAULT;
        try {
            dataWriter = (DataWriter)this._dataWriterFactory.create_entityI(dataWriterQos, bl, dataWriterListener, n, new Object[]{topic, dataWriterQos == DATAWRITER_QOS_USE_TOPIC_QOS ? Boolean.TRUE : Boolean.FALSE, bl || dataWriterQos == DATAWRITER_QOS_USE_TOPIC_QOS ? null : dataWriterQos.type_support.plugin_data});
        }
        catch (RETCODE_ERROR rETCODE_ERROR) {
            ModuleLogger.DDS.logStackTrace(PublisherImpl.class, "create_datawriter", rETCODE_ERROR);
            return null;
        }
        return dataWriter;
    }

    public DataWriter create_datawriter_with_profile(Topic topic, String string, String string2, DataWriterListener dataWriterListener, int n) {
        DataWriterQos dataWriterQos = new DataWriterQos();
        DataWriter dataWriter = null;
        this.check_aliveI();
        if (string2 == null) {
            string2 = PublisherImpl.DDS_Publisher_get_default_profile(this.get_native_pointer());
            string = PublisherImpl.DDS_Publisher_get_default_profile_library(this.get_native_pointer());
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
        }
        if (string == null) {
            string = PublisherImpl.DDS_Publisher_get_default_library(this.get_native_pointer());
        }
        if (string == null) {
            Utilities.rethrow(NULL_LIBRARY);
        }
        DomainParticipantFactory.get_instance().get_datawriter_qos_from_profile_w_topic_name(dataWriterQos, string, string2, topic.get_name());
        dataWriter = this.create_datawriter(topic, dataWriterQos, dataWriterListener, n);
        dataWriterQos = null;
        return dataWriter;
    }

    public void delete_datawriter(DataWriter dataWriter) {
        this._dataWriterFactory.delete_entityI(dataWriter);
    }

    public DataWriter lookup_datawriter(String string) {
        this.check_aliveI();
        this.check_for_null_argumentI(string);
        DataWriter dataWriter = null;
        long l = PublisherImpl.DDS_Publisher_lookup_datawriter(this.get_native_pointer(), string);
        if (l != 0L) {
            dataWriter = (DataWriter)PublisherImpl.get_datawriter(l);
        }
        return dataWriter;
    }

    public void get_qos(PublisherQos publisherQos) {
        this.get_untyped_qos(publisherQos);
        publisherQos.asynchronous_publisher.thread.priority = this._cachedAsynchronousPublisherThreadPriority;
        publisherQos.asynchronous_publisher.asynchronous_batch_thread.priority = this._cachedAsynchronousPublisherBatchThreadPriority;
    }

    public void set_qos(PublisherQos publisherQos) {
        boolean bl;
        boolean bl2 = bl = publisherQos == DomainParticipant.PUBLISHER_QOS_DEFAULT;
        if (!bl) {
            if (publisherQos.asynchronous_publisher.thread.priority != this._cachedAsynchronousPublisherThreadPriority) {
                Utilities.rethrow(IMMUTABLE_QOS);
            }
            if (publisherQos.asynchronous_publisher.asynchronous_batch_thread.priority != this._cachedAsynchronousPublisherBatchThreadPriority) {
                Utilities.rethrow(IMMUTABLE_QOS);
            }
        } else {
            this.get_participant().get_default_publisher_qos(publisherQos);
            bl = false;
        }
        this.set_untyped_qos(publisherQos, bl, null);
    }

    public void set_qos_with_profile(String string, String string2) {
        PublisherQos publisherQos = new PublisherQos();
        this.check_aliveI();
        if (string2 == null) {
            string2 = PublisherImpl.DDS_Publisher_get_default_profile(this.get_native_pointer());
            string = PublisherImpl.DDS_Publisher_get_default_profile_library(this.get_native_pointer());
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
        }
        if (string == null) {
            string = PublisherImpl.DDS_Publisher_get_default_library(this.get_native_pointer());
        }
        if (string == null) {
            Utilities.rethrow(NULL_LIBRARY);
        }
        DomainParticipantFactory.get_instance().get_publisher_qos_from_profile(publisherQos, string, string2);
        this.set_qos(publisherQos);
        publisherQos = null;
    }

    public String get_default_library() {
        this.check_aliveI();
        String string = PublisherImpl.DDS_Publisher_get_default_library(this.get_native_pointer());
        return string;
    }

    public void set_default_library(String string) {
        this.check_aliveI();
        int n = PublisherImpl.DDS_Publisher_set_default_library(this.get_native_pointer(), string);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public String get_default_profile() {
        this.check_aliveI();
        String string = PublisherImpl.DDS_Publisher_get_default_profile(this.get_native_pointer());
        return string;
    }

    public void set_default_profile(String string, String string2) {
        this.check_aliveI();
        int n = PublisherImpl.DDS_Publisher_set_default_profile(this.get_native_pointer(), string, string2);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public String get_default_profile_library() {
        this.check_aliveI();
        String string = PublisherImpl.DDS_Publisher_get_default_profile_library(this.get_native_pointer());
        return string;
    }

    public PublisherListener get_listener() {
        return (PublisherListener)this.get_untyped_listenerI();
    }

    public void set_listener(PublisherListener publisherListener, int n) {
        this.set_untyped_listenerI(publisherListener, n);
    }

    public void suspend_publications() {
        this.check_aliveI();
        int n = PublisherImpl.DDS_Publisher_suspend_publications(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void resume_publications() {
        this.check_aliveI();
        int n = PublisherImpl.DDS_Publisher_resume_publications(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void begin_coherent_changes() {
        this.check_aliveI();
        int n = PublisherImpl.DDS_Publisher_begin_coherent_changes(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void end_coherent_changes() {
        this.check_aliveI();
        int n = PublisherImpl.DDS_Publisher_end_coherent_changes(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void copy_from_topic_qos(DataWriterQos dataWriterQos, TopicQos topicQos) {
        this.check_aliveI();
        this.check_for_null_argumentI(dataWriterQos);
        this.check_for_null_argumentI(topicQos);
        dataWriterQos.durability.copy_from(topicQos.durability);
        dataWriterQos.durability_service.copy_from(topicQos.durability_service);
        dataWriterQos.deadline.copy_from(topicQos.deadline);
        dataWriterQos.latency_budget.copy_from(topicQos.latency_budget);
        dataWriterQos.liveliness.copy_from(topicQos.liveliness);
        dataWriterQos.reliability.copy_from(topicQos.reliability);
        dataWriterQos.destination_order.copy_from(topicQos.destination_order);
        dataWriterQos.history.copy_from(topicQos.history);
        dataWriterQos.resource_limits.copy_from(topicQos.resource_limits);
        dataWriterQos.transport_priority.copy_from(topicQos.transport_priority);
        dataWriterQos.lifespan.copy_from(topicQos.lifespan);
        dataWriterQos.ownership.copy_from(topicQos.ownership);
    }

    public void delete_contained_entities() {
        this.check_aliveI();
        int n = PublisherImpl.DDS_Publisher_delete_contained_entities(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void get_all_datawriters(DataWriterSeq dataWriterSeq) {
        this.check_aliveI();
        this.check_for_null_argumentI(dataWriterSeq);
        int n = PublisherImpl.DDS_Publisher_get_all_datawriters(this.get_native_pointer(), dataWriterSeq.getNativeSequence());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public DomainParticipant get_participant() {
        if (!this.is_alive()) {
            return null;
        }
        DomainParticipant domainParticipant = null;
        long l = PublisherImpl.DDS_Publisher_get_participant(this.get_native_pointer());
        if (l != 0L) {
            domainParticipant = (DomainParticipant)DomainParticipantImpl.get_participantI(l);
        }
        return domainParticipant;
    }

    public void wait_for_acknowledgments(Duration_t duration_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(duration_t);
        long l = PublisherImpl.get_scratchpad_timeoutI(this.get_native_pointer());
        duration_t.push_to_nativeI(l);
        int n = PublisherImpl.DDS_Publisher_wait_for_acknowledgments(this.get_native_pointer(), l);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void wait_for_asynchronous_publishing(Duration_t duration_t) {
        this.check_aliveI();
        this.check_for_null_argumentI(duration_t);
        long l = PublisherImpl.get_scratchpad_timeoutI(this.get_native_pointer());
        duration_t.push_to_nativeI(l);
        int n = PublisherImpl.DDS_Publisher_wait_for_asynchronous_publishing(this.get_native_pointer(), l);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public DataWriter lookup_datawriter_by_name(String string) {
        long l = PublisherImpl.DDS_Publisher_lookup_datawriter_by_name(this.get_native_pointer(), string);
        if (l != 0L) {
            return (DataWriter)DataWriterImpl.get_datawriterI(l);
        }
        return null;
    }

    public DataWriter assert_topic_and_create_datawriter(String string, String string2, String string3, String string4, DataWriterQos dataWriterQos, DataWriterListener dataWriterListener, int n) {
        this.check_for_null_argumentI(string3);
        this.check_for_null_argumentI(string4);
        this.check_for_null_argumentI(dataWriterQos);
        Topic topic = null;
        DataWriter dataWriter = null;
        topic = ((DomainParticipantImpl)this.get_participant()).check_create_and_enable_topic_if_no_existI(string3, string4);
        if (topic == null) {
            return null;
        }
        dataWriter = this.create_datawriter(topic, dataWriterQos, dataWriterListener, n);
        if (dataWriter == null) {
            return null;
        }
        return dataWriter;
    }

    public void release_topic_and_delete_datawriter(String string, String string2, DataWriter dataWriter) {
        this.check_for_null_argumentI(dataWriter);
        Topic topic = null;
        topic = dataWriter.get_topic();
        this.delete_datawriter(dataWriter);
        this.get_participant().delete_topic(topic);
    }

    public void on_native_entity_finalized() {
        super.cleanup();
        this._dataWriterFactory.cleanup();
    }

    public static native Object get_publisherI(long var0);

    private static native int DDS_Publisher_get_default_datawriter_qos_w_topic_name(long var0, long var2, String var4);

    private static native int DDS_Publisher_set_default_datawriter_qos(long var0, long var2, boolean var4, Object var5);

    private static native int DDS_Publisher_set_default_datawriter_qos_with_profile(long var0, String var2, String var3);

    private static native long get_scratchpad_datawriter_qosI(long var0);

    private static native long DDS_Publisher_create_datawriter_disabledI(long var0, long var2, boolean[] var4, long var5, long var7, boolean var9, boolean var10, long var11, int var13, Object var14);

    private static native int DDS_Publisher_delete_datawriter(long var0, long var2);

    private static native int initialize_native_to_java_datawriter_pointer(long var0, Object var2, Object var3);

    private static native long DDS_Publisher_lookup_datawriter(long var0, String var2);

    private static native Object get_datawriter(long var0);

    private static native int DDS_Publisher_suspend_publications(long var0);

    private static native int DDS_Publisher_resume_publications(long var0);

    private static native int DDS_Publisher_begin_coherent_changes(long var0);

    private static native int DDS_Publisher_end_coherent_changes(long var0);

    private static native int DDS_Publisher_set_qos(long var0, long var2, boolean var4);

    private static native int DDS_Publisher_get_qos(long var0, long var2);

    private static native String DDS_Publisher_get_default_library(long var0);

    private static native int DDS_Publisher_set_default_library(long var0, String var2);

    private static native String DDS_Publisher_get_default_profile(long var0);

    private static native int DDS_Publisher_set_default_profile(long var0, String var2, String var3);

    private static native String DDS_Publisher_get_default_profile_library(long var0);

    private static native long get_scratchpad_publisher_qosI(long var0);

    private static native int DDS_Publisher_delete_contained_entities(long var0);

    private static native long DDS_Publisher_get_participant(long var0);

    private static native int DDS_Publisher_wait_for_acknowledgments(long var0, long var2);

    private static native int DDS_Publisher_wait_for_asynchronous_publishing(long var0, long var2);

    private static native long get_scratchpad_timeoutI(long var0);

    private static native int DDS_Publisher_get_all_datawriters(long var0, long var2);

    private static native long DDS_Publisher_lookup_datawriter_by_name(long var0, String var2);

    private final class DataWriterFactoryMixin
    extends NativeFactoryMixin {
        public DataWriterFactoryMixin() {
            super(PublisherImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return PublisherImpl.get_scratchpad_datawriter_qosI(l);
        }

        protected Entity wrap_with_java_entity(long l, Listener listener, int n, Object[] objectArray) {
            return super.wrap_with_java_entity(l, listener, n, objectArray);
        }

        protected long create_native_entity(long l, long l2, boolean bl, long l3, int n, boolean[] blArray, Object[] objectArray) {
            Topic topic = (Topic)objectArray[0];
            AbstractNativeObject.check_aliveI((NativeObject)((Object)topic));
            long l4 = ((NativeObject)((Object)topic)).get_native_pointer();
            Boolean bl2 = (Boolean)objectArray[1];
            long l5 = ((NativeTopicDescription)objectArray[0]).get_type_support_native_peer();
            Object object = objectArray[2];
            return PublisherImpl.DDS_Publisher_create_datawriter_disabledI(l, l5, blArray, l4, l2, bl, bl2, l3, n, object);
        }

        protected Entity create_java_entity(long l, Listener listener, int n, Object[] objectArray) {
            TopicImpl topicImpl = (TopicImpl)objectArray[0];
            return topicImpl.create_datawriterI(l, (DataWriterListener)listener, n);
        }

        protected int initialize_native_to_java_pointer(long l, Entity entity) {
            KeyHash_t keyHash_t = ((DataWriterImpl)entity).get_key_hash();
            return PublisherImpl.initialize_native_to_java_datawriter_pointer(l, entity, keyHash_t);
        }

        protected int destroy_native_entity(long l, long l2) {
            return PublisherImpl.DDS_Publisher_delete_datawriter(l, l2);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            String string = (String)object;
            return PublisherImpl.DDS_Publisher_get_default_datawriter_qos_w_topic_name(l, l2, string);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            if (bl2) {
                return PublisherImpl.DDS_Publisher_set_default_datawriter_qos_with_profile(l, (String)objectArray[0], (String)objectArray[1]);
            }
            return PublisherImpl.DDS_Publisher_set_default_datawriter_qos(l, l2, bl, objectArray[0]);
        }
    }

    private final class PublisherQosMixin
    extends NativeStructMixin {
        public PublisherQosMixin() {
            super(PublisherImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return PublisherImpl.get_scratchpad_publisher_qosI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return PublisherImpl.DDS_Publisher_get_qos(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return PublisherImpl.DDS_Publisher_set_qos(l, l2, bl);
        }
    }
}

